/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ExitCodes {
    public static final int ERROR_FLAG = 4;
    public static final int MISSING_CLASS_FLAG = 2;
    public static final int BUGS_FOUND_FLAG = 1;

    public static int from(int errors, int missingClasses, int bugs) {
        Logger logger = LoggerFactory.getLogger(ExitCodes.class);
        int exitCode = 0;
        logger.info("Calculating exit code...");
        if (errors > 0) {
            exitCode |= 4;
            logger.debug("Setting 'errors encountered' flag ({})", (Object)4);
        }
        if (missingClasses > 0) {
            exitCode |= 2;
            logger.debug("Setting 'missing class' flag ({})", (Object)2);
        }
        if (bugs > 0) {
            exitCode |= 1;
            logger.debug("Setting 'bugs found' flag ({})", (Object)1);
        }
        logger.debug("Exit code set to: {}", (Object)exitCode);
        return exitCode;
    }
}

