/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.TypeQualifierNullnessAnnotationDatabase;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Code;

public abstract class TypeReturnNull
extends OpcodeStackDetector {
    protected final BugAccumulator bugAccumulator;

    public TypeReturnNull(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Code code) {
        SignatureParser sp = new SignatureParser(this.getMethodSig());
        String returnSignature = sp.getReturnTypeSignature();
        if (!this.matchesReturnSignature(returnSignature)) {
            return;
        }
        if (this.isExplicitlyNullable()) {
            return;
        }
        super.visit(code);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private boolean isExplicitlyNullable() {
        XMethod xMethod;
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        TypeQualifierNullnessAnnotationDatabase nullnessAnnotationDatabase = analysisContext.getNullnessAnnotationDatabase();
        NullnessAnnotation na = nullnessAnnotationDatabase.getResolvedAnnotation(xMethod = this.getXMethod(), true);
        return na != null && na != NullnessAnnotation.NONNULL;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 176 && this.getPrevOpcode(1) == 1) {
            this.accumulateBug();
        }
    }

    protected abstract boolean matchesReturnSignature(String var1);

    protected abstract void accumulateBug();
}

