/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.detect.BuildStringPassthruGraph;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.Type;

public class FindSqlInjection
implements Detector {
    private static final String[] PREPARE_STATEMENT_SIGNATURES = new String[]{"(Ljava/lang/String;)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;"};
    private static final MethodDescriptor[] EXECUTE_METHODS = new MethodDescriptor[]{new MethodDescriptor("java/sql/Statement", "executeQuery", "(Ljava/lang/String;)Ljava/sql/ResultSet;"), new MethodDescriptor("java/sql/Statement", "executeUpdate", "(Ljava/lang/String;)I"), new MethodDescriptor("java/sql/Statement", "executeUpdate", "(Ljava/lang/String;I)I"), new MethodDescriptor("java/sql/Statement", "executeUpdate", "(Ljava/lang/String;[I)I"), new MethodDescriptor("java/sql/Statement", "executeUpdate", "(Ljava/lang/String;[Ljava/lang/String;)I"), new MethodDescriptor("java/sql/Statement", "executeLargeUpdate", "(Ljava/lang/String;)J"), new MethodDescriptor("java/sql/Statement", "executeLargeUpdate", "(Ljava/lang/String;I)J"), new MethodDescriptor("java/sql/Statement", "executeLargeUpdate", "(Ljava/lang/String;[I)J"), new MethodDescriptor("java/sql/Statement", "executeLargeUpdate", "(Ljava/lang/String;[Ljava/lang/String;)J"), new MethodDescriptor("java/sql/Statement", "execute", "(Ljava/lang/String;)Z"), new MethodDescriptor("java/sql/Statement", "execute", "(Ljava/lang/String;I)Z"), new MethodDescriptor("java/sql/Statement", "execute", "(Ljava/lang/String;[I)Z"), new MethodDescriptor("java/sql/Statement", "execute", "(Ljava/lang/String;[Ljava/lang/String;)Z"), new MethodDescriptor("java/sql/Statement", "addBatch", "(Ljava/lang/String;)V")};
    BugReporter bugReporter;
    BugAccumulator bugAccumulator;
    final Map<MethodDescriptor, int[]> preparedStatementMethods;
    final Map<MethodDescriptor, int[]> executeMethods;
    final Set<MethodDescriptor> allMethods = new HashSet<MethodDescriptor>();
    static final Pattern openQuotePattern = Pattern.compile("((^')|[^\\p{Alnum}]')$");
    static final Pattern closeQuotePattern = Pattern.compile("^'($|[^\\p{Alnum}])");
    Method method;
    ClassContext classContext;

    public FindSqlInjection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        HashSet<BuildStringPassthruGraph.MethodParameter> baseExecuteMethods = new HashSet<BuildStringPassthruGraph.MethodParameter>();
        for (MethodDescriptor executeMethod : EXECUTE_METHODS) {
            baseExecuteMethods.add(new BuildStringPassthruGraph.MethodParameter(executeMethod, 0));
        }
        this.executeMethods = Global.getAnalysisCache().getDatabase(BuildStringPassthruGraph.StringPassthruDatabase.class).findLinkedMethods(baseExecuteMethods);
        HashSet<BuildStringPassthruGraph.MethodParameter> basePrepareMethods = new HashSet<BuildStringPassthruGraph.MethodParameter>();
        for (String signature : PREPARE_STATEMENT_SIGNATURES) {
            basePrepareMethods.add(new BuildStringPassthruGraph.MethodParameter(new MethodDescriptor("java/sql/Connection", "prepareStatement", signature), 0));
        }
        this.preparedStatementMethods = Global.getAnalysisCache().getDatabase(BuildStringPassthruGraph.StringPassthruDatabase.class).findLinkedMethods(basePrepareMethods);
        this.allMethods.addAll(this.executeMethods.keySet());
        this.allMethods.addAll(this.preparedStatementMethods.keySet());
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        if (!PreorderVisitor.hasInterestingMethod(javaClass.getConstantPool(), this.allMethods)) {
            return;
        }
        for (Method method : methodList = javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("FindSqlInjection caught exception while analyzing " + classContext.getFullyQualifiedMethodName(method), e);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("FindSqlInjection caught exception while analyzing " + classContext.getFullyQualifiedMethodName(method), e);
            }
            catch (RuntimeException e) {
                this.bugReporter.logError("FindSqlInjection caught exception while analyzing " + classContext.getFullyQualifiedMethodName(method), e);
            }
        }
    }

    private boolean isStringAppend(Instruction ins, ConstantPoolGen cpg) {
        INVOKEVIRTUAL invoke;
        if (ins instanceof INVOKEVIRTUAL && "append".equals((invoke = (INVOKEVIRTUAL)ins).getMethodName(cpg)) && invoke.getClassName(cpg).startsWith("java.lang.StringB")) {
            String sig = invoke.getSignature(cpg);
            char firstChar = sig.charAt(1);
            return firstChar == '[' || firstChar == 'L';
        }
        return false;
    }

    private boolean isConstantStringLoad(Location location, ConstantPoolGen cpg) {
        LDC load;
        Object value;
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof LDC && (value = (load = (LDC)ins).getValue(cpg)) instanceof String;
    }

    public static boolean isOpenQuote(String s) {
        return openQuotePattern.matcher(s).find();
    }

    public static boolean isCloseQuote(String s) {
        return closeQuotePattern.matcher(s).find();
    }

    private StringAppendState updateStringAppendState(Location location, ConstantPoolGen cpg, StringAppendState stringAppendState) {
        InstructionHandle handle = location.getHandle();
        Instruction ins = handle.getInstruction();
        if (!this.isConstantStringLoad(location, cpg)) {
            throw new IllegalArgumentException("instruction must be LDC");
        }
        LDC load = (LDC)ins;
        Object value = load.getValue(cpg);
        String stringValue = ((String)value).trim();
        if (stringValue.startsWith(",") || stringValue.endsWith(",")) {
            stringAppendState.setSawComma(handle);
        }
        if (FindSqlInjection.isCloseQuote(stringValue) && stringAppendState.getSawOpenQuote(handle)) {
            stringAppendState.setSawCloseQuote(handle);
        }
        if (FindSqlInjection.isOpenQuote(stringValue)) {
            stringAppendState.setSawOpenQuote(handle);
        }
        return stringAppendState;
    }

    private StringAppendState getStringAppendState(CFG cfg, ConstantPoolGen cpg) throws CFGBuilderException {
        StringAppendState stringAppendState = new StringAppendState();
        String sig = this.method.getSignature();
        if ((sig = sig.substring(0, sig.indexOf(41))).indexOf("java/lang/String") >= 0) {
            stringAppendState.setSawInitialTaint();
        }
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            GETFIELD getfield;
            String sig2;
            Location location = i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (this.isConstantStringLoad(location, cpg)) {
                stringAppendState = this.updateStringAppendState(location, cpg, stringAppendState);
                continue;
            }
            if (this.isStringAppend(ins, cpg)) {
                stringAppendState.setSawAppend(handle);
                Location prevLocation = this.getPreviousLocation(cfg, location, true);
                if (prevLocation == null || this.isSafeValue(prevLocation, cpg)) continue;
                stringAppendState.setSawUnsafeAppend(handle);
                continue;
            }
            if (ins instanceof InvokeInstruction) {
                InvokeInstruction inv = (InvokeInstruction)ins;
                String sig1 = inv.getSignature(cpg);
                String sig22 = sig1.substring(sig1.indexOf(41));
                if (sig22.indexOf("java/lang/String") < 0) continue;
                String methodName = inv.getMethodName(cpg);
                String className = inv.getClassName(cpg);
                if ("valueOf".equals(methodName) && "java.lang.String".equals(className) && "(Ljava/lang/Object;)Ljava/lang/String;".equals(sig1)) {
                    try {
                        String sig3;
                        Type operandType;
                        TypeDataflow typeDataflow = this.classContext.getTypeDataflow(this.method);
                        TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
                        if (!frame.isValid() || (operandType = (Type)frame.getTopValue()).equals((Object)TopType.instance()) || "Ljava/lang/String;".equals(sig3 = operandType.getSignature())) continue;
                        stringAppendState.setSawTaint(handle);
                    }
                    catch (CheckedAnalysisException e) {
                        stringAppendState.setSawTaint(handle);
                    }
                    continue;
                }
                if (className.startsWith("java.lang.String") || "java.lang.Long".equals(className) || "java.lang.Integer".equals(className) || "java.lang.Float".equals(className) || "java.lang.Double".equals(className) || "java.lang.Short".equals(className) || "java.lang.Byte".equals(className) || "java.lang.Character".equals(className) || methodName.startsWith("to") && methodName.endsWith("String") && methodName.length() > 8) continue;
                if (className.startsWith("javax.servlet") && methodName.startsWith("get")) {
                    stringAppendState.setSawTaint(handle);
                    stringAppendState.setSawSeriousTaint(handle);
                    continue;
                }
                stringAppendState.setSawTaint(handle);
                continue;
            }
            if (!(ins instanceof GETFIELD) || (sig2 = (getfield = (GETFIELD)ins).getSignature(cpg)).indexOf("java/lang/String") < 0) continue;
            stringAppendState.setSawTaint(handle);
        }
        return stringAppendState;
    }

    private boolean isSafeValue(Location location, ConstantPoolGen cpg) throws CFGBuilderException {
        GETSTATIC getStatic;
        Location prev2;
        CFG cfg;
        Location prev;
        String methodName;
        Instruction prevIns = location.getHandle().getInstruction();
        if (prevIns instanceof LDC || prevIns instanceof GETSTATIC) {
            return true;
        }
        if (prevIns instanceof InvokeInstruction && (methodName = ((InvokeInstruction)prevIns).getMethodName(cpg)).startsWith("to") && methodName.endsWith("String") && methodName.length() > 8) {
            return true;
        }
        return prevIns instanceof AALOAD && (prev = this.getPreviousLocation(cfg = this.classContext.getCFG(this.method), location, true)) != null && (prev2 = this.getPreviousLocation(cfg, prev, true)) != null && prev2.getHandle().getInstruction() instanceof GETSTATIC && "[Ljava/lang/String;".equals((getStatic = (GETSTATIC)prev2.getHandle().getInstruction()).getSignature(cpg));
    }

    @CheckForNull
    private InstructionHandle getPreviousInstruction(InstructionHandle handle, boolean skipNops) {
        while (handle.getPrev() != null) {
            Instruction prevIns = (handle = handle.getPrev()).getInstruction();
            if (prevIns instanceof NOP && skipNops) continue;
            return handle;
        }
        return null;
    }

    @CheckForNull
    private Location getPreviousLocation(CFG cfg, Location startLocation, boolean skipNops) {
        InstructionHandle lastInstruction;
        Location loc = startLocation;
        InstructionHandle prev = this.getPreviousInstruction(loc.getHandle(), skipNops);
        if (prev != null) {
            return new Location(prev, loc.getBasicBlock());
        }
        BasicBlock block = loc.getBasicBlock();
        do {
            if ((block = cfg.getPredecessorWithEdgeType(block, 0)) != null) continue;
            return null;
        } while ((lastInstruction = block.getLastInstruction()) == null);
        return new Location(lastInstruction, block);
    }

    private BugInstance generateBugInstance(JavaClass javaClass, MethodGen methodGen, InstructionHandle handle, StringAppendState stringAppendState, boolean isExecute) {
        int priority = 3;
        boolean sawSeriousTaint = false;
        if (stringAppendState.getSawAppend(handle)) {
            if (stringAppendState.getSawOpenQuote(handle) && stringAppendState.getSawCloseQuote(handle)) {
                priority = 1;
            } else if (stringAppendState.getSawComma(handle)) {
                priority = 2;
            }
            if (!stringAppendState.getSawUnsafeAppend(handle)) {
                priority += 2;
            } else if (stringAppendState.getSawSeriousTaint(handle)) {
                --priority;
                sawSeriousTaint = true;
            } else if (!stringAppendState.getSawTaint(handle)) {
                ++priority;
            }
        }
        String description = isExecute ? "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE" : "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING";
        BugInstance bug = new BugInstance(this, description, priority);
        bug.addClassAndMethod(methodGen, javaClass.getSourceFileName());
        if (sawSeriousTaint) {
            bug.addString("non-constant SQL string involving HTTP taint");
        }
        return bug;
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        JavaClass javaClass = classContext.getJavaClass();
        ValueNumberDataflow vnd = classContext.getValueNumberDataflow(method);
        Set<ValueNumber> passthruParams = this.getPassthruParams(vnd, method, javaClass);
        this.method = method;
        this.classContext = classContext;
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        ConstantPoolGen cpg = methodGen.getConstantPool();
        CFG cfg = classContext.getCFG(method);
        StringAppendState stringAppendState = this.getStringAppendState(cfg, cpg);
        ConstantDataflow dataflow = classContext.getConstantDataflow(method);
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location prev;
            int paramNumber;
            boolean executeMethod;
            Location location = i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction invoke = (InvokeInstruction)ins;
            MethodDescriptor md = new MethodDescriptor(invoke, cpg);
            int[] params = this.preparedStatementMethods.get(md);
            if (params != null) {
                executeMethod = false;
                paramNumber = params[0];
            } else {
                params = this.executeMethods.get(md);
                if (params == null) continue;
                executeMethod = true;
                paramNumber = params[0];
            }
            ConstantFrame frame = (ConstantFrame)dataflow.getFactAtLocation(location);
            SignatureParser parser = new SignatureParser(invoke.getSignature(cpg));
            Constant value = (Constant)frame.getArgument(invoke, cpg, paramNumber, parser);
            ValueNumber vn = (ValueNumber)((ValueNumberFrame)vnd.getFactAtLocation(location)).getArgument(invoke, cpg, paramNumber, parser);
            if (value.isConstantString() || passthruParams.contains(vn) || (prev = this.getValueNumberCreationLocation(vnd, vn)) != null && this.isSafeValue(prev, cpg)) continue;
            BugInstance bug = this.generateBugInstance(javaClass, methodGen, location.getHandle(), stringAppendState, executeMethod);
            this.bugAccumulator.accumulateBug(bug, SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, javaClass.getSourceFileName(), location.getHandle()));
        }
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private Location getValueNumberCreationLocation(ValueNumberDataflow vnd, ValueNumber vn) {
        ConstantPoolGen cpg = vnd.getCFG().getMethodGen().getConstantPool();
        Iterator<Location> it = vnd.getCFG().locationIterator();
        while (it.hasNext()) {
            Location loc = it.next();
            if (loc.getHandle().getInstruction().produceStack(cpg) != 1) continue;
            try {
                ValueNumberFrame vnf = (ValueNumberFrame)vnd.getFactAfterLocation(loc);
                if (!((ValueNumber)vnf.getTopValue()).equals(vn)) continue;
                return loc;
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("While analyzing " + vnd.getCFG().getMethodGen() + " at " + loc, e);
            }
        }
        return null;
    }

    private Set<ValueNumber> getPassthruParams(ValueNumberDataflow vnd, Method method, JavaClass javaClass) {
        XMethod xMethod = XFactory.createXMethod(javaClass, method);
        HashSet<ValueNumber> passthruParams = new HashSet<ValueNumber>();
        int[] p = this.preparedStatementMethods.get(xMethod);
        if (p != null) {
            for (int pNum : p) {
                passthruParams.add(((ValueNumberAnalysis)vnd.getAnalysis()).getEntryValueForParameter(pNum));
            }
        }
        if ((p = this.executeMethods.get(xMethod)) != null) {
            for (int pNum : p) {
                passthruParams.add(((ValueNumberAnalysis)vnd.getAnalysis()).getEntryValueForParameter(pNum));
            }
        }
        return passthruParams;
    }

    @Override
    public void report() {
    }

    private static class StringAppendState {
        int sawOpenQuote = Integer.MAX_VALUE;
        int sawCloseQuote = Integer.MAX_VALUE;
        int sawComma = Integer.MAX_VALUE;
        int sawAppend = Integer.MAX_VALUE;
        int sawUnsafeAppend = Integer.MAX_VALUE;
        int sawTaint = Integer.MAX_VALUE;
        int sawSeriousTaint = Integer.MAX_VALUE;

        private StringAppendState() {
        }

        public boolean getSawOpenQuote(InstructionHandle handle) {
            return this.sawOpenQuote <= handle.getPosition();
        }

        public boolean getSawCloseQuote(InstructionHandle handle) {
            return this.sawCloseQuote <= handle.getPosition();
        }

        public boolean getSawComma(InstructionHandle handle) {
            return this.sawComma <= handle.getPosition();
        }

        public boolean getSawAppend(InstructionHandle handle) {
            return this.sawAppend <= handle.getPosition();
        }

        public boolean getSawUnsafeAppend(InstructionHandle handle) {
            return this.sawUnsafeAppend <= handle.getPosition();
        }

        public boolean getSawTaint(InstructionHandle handle) {
            return this.sawTaint <= handle.getPosition();
        }

        public boolean getSawSeriousTaint(InstructionHandle handle) {
            return this.sawSeriousTaint <= handle.getPosition();
        }

        public void setSawOpenQuote(InstructionHandle handle) {
            this.sawOpenQuote = Math.min(this.sawOpenQuote, handle.getPosition());
        }

        public void setSawCloseQuote(InstructionHandle handle) {
            this.sawCloseQuote = Math.min(this.sawCloseQuote, handle.getPosition());
        }

        public void setSawComma(InstructionHandle handle) {
            this.sawComma = Math.min(this.sawComma, handle.getPosition());
        }

        public void setSawAppend(InstructionHandle handle) {
            this.sawAppend = Math.min(this.sawAppend, handle.getPosition());
        }

        public void setSawUnsafeAppend(InstructionHandle handle) {
            this.sawUnsafeAppend = Math.min(this.sawUnsafeAppend, handle.getPosition());
        }

        public void setSawSeriousTaint(InstructionHandle handle) {
            this.sawSeriousTaint = Math.min(this.sawSeriousTaint, handle.getPosition());
        }

        public void setSawTaint(InstructionHandle handle) {
            this.sawTaint = Math.min(this.sawTaint, handle.getPosition());
        }

        public void setSawInitialTaint() {
            this.sawTaint = 0;
        }
    }
}

