/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.type.ExceptionSet;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.Collection;
import javax.annotation.CheckForNull;

public class TypeDataflow
extends Dataflow<TypeFrame, TypeAnalysis> {
    public TypeDataflow(CFG cfg, TypeAnalysis analysis) {
        super(cfg, analysis);
    }

    public ExceptionSet getEdgeExceptionSet(Edge edge) {
        return ((TypeAnalysis)this.getAnalysis()).getEdgeExceptionSet(edge);
    }

    @CheckForNull
    public LocationAndFactPair getLocationAndFactForInstruction(int pc) {
        Collection<Location> locations = this.getCFG().getLocationsContainingInstructionWithOffset(pc);
        LocationAndFactPair result = null;
        for (Location location : locations) {
            try {
                TypeFrame frame = (TypeFrame)this.getFactAtLocation(location);
                if (!frame.isValid()) continue;
                result = new LocationAndFactPair(location, frame);
                break;
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
            }
        }
        return result;
    }

    public static class LocationAndFactPair {
        public final Location location;
        public final TypeFrame frame;

        LocationAndFactPair(Location location, TypeFrame frame) {
            this.location = location;
            this.frame = frame;
        }
    }
}

