/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.LaunchAppropriateUI;
import edu.umd.cs.findbugs.Plugin;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOG = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    public static final String WEBSITE = "https://spotbugs.github.io/";
    public static final String VERSION_STRING;
    @Deprecated
    public static final String RELEASE;
    private static String applicationName;
    private static String applicationVersion;

    public static void registerApplication(String name, String version) {
        applicationName = name;
        applicationVersion = version;
    }

    @CheckForNull
    public static String getApplicationName() {
        return applicationName;
    }

    @CheckForNull
    public static String getApplicationVersion() {
        return applicationVersion;
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            Version.printVersion(false);
            return;
        }
        String arg = argv[0];
        if ("-release".equals(arg)) {
            LOG.info(VERSION_STRING);
        } else if ("-plugins".equals(arg)) {
            DetectorFactoryCollection.instance();
            for (Plugin p : Plugin.getAllPlugins()) {
                String website;
                LOG.info("Plugin: {}", (Object)p.getPluginId());
                LOG.info("  description: {}", (Object)p.getShortDescription());
                LOG.info("     provider: {}", (Object)p.getProvider());
                String version = p.getVersion();
                if (version != null && version.length() > 0) {
                    LOG.info("      version: {}", (Object)version);
                }
                if ((website = p.getWebsite()) != null && website.length() > 0) {
                    LOG.info("      website: {}", (Object)website);
                }
                LOG.info("");
            }
        } else if ("-configuration".equals(arg)) {
            Version.printVersion(true);
        } else {
            Version.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        LOG.error("Usage: {} [(-release|-date|-props|-configuration)]", (Object)Version.class.getName());
    }

    public static void printVersion(boolean justPrintConfiguration) {
        LOG.info("SpotBugs {}", (Object)VERSION_STRING);
        if (!justPrintConfiguration) {
            return;
        }
        for (Plugin plugin : Plugin.getAllPlugins()) {
            Plugin parent;
            LOG.info("Plugin {}, version {}, loaded from {}", new Object[]{plugin.getPluginId(), plugin.getVersion(), plugin.getPluginLoader().getURL()});
            if (plugin.isCorePlugin()) {
                LOG.info("  is core plugin");
            }
            if (plugin.isInitialPlugin()) {
                LOG.info("  is initial plugin");
            }
            if (plugin.isEnabledByDefault()) {
                LOG.info("  is enabled by default");
            }
            if (plugin.isGloballyEnabled()) {
                LOG.info("  is globally enabled");
            }
            if ((parent = plugin.getParentPlugin()) != null) {
                LOG.info("  has parent plugin {}", (Object)parent.getPluginId());
            }
            for (DetectorFactory factory : plugin.getDetectorFactories()) {
                LOG.info("  detector {}", (Object)factory.getShortName());
            }
            LOG.info("");
        }
    }

    static {
        applicationName = "";
        applicationVersion = "";
        URL u = Version.class.getResource(Version.class.getSimpleName() + ".class");
        boolean fromFile = "file".equals(u.getProtocol());
        String version = "(Unknown)";
        if (!fromFile) {
            try {
                Enumeration<URL> resources = Version.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (resources.hasMoreElements()) {
                    InputStream is = resources.nextElement().openStream();
                    Throwable throwable = null;
                    try {
                        Manifest manifest = new Manifest(is);
                        String mainClass = manifest.getMainAttributes().getValue("Main-Class");
                        if (!LaunchAppropriateUI.class.getName().equals(mainClass)) continue;
                        version = manifest.getMainAttributes().getValue("Bundle-Version");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            catch (Exception exception) {}
        } else {
            version = "Development";
        }
        RELEASE = VERSION_STRING = version;
    }
}

