/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.io.IO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyBundle {
    private final Properties properties;
    volatile Rewriter rewriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rewriter getRewriter() {
        if (this.rewriter == null) {
            PropertyBundle propertyBundle = this;
            synchronized (propertyBundle) {
                if (this.rewriter == null) {
                    this.rewriter = new Rewriter();
                }
            }
        }
        return this.rewriter;
    }

    public PropertyBundle() {
        this.properties = new Properties();
    }

    public PropertyBundle(Properties properties) {
        this.properties = (Properties)properties.clone();
    }

    public PropertyBundle copy() {
        return new PropertyBundle(this.properties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void loadPropertiesFromString(String contents) {
        if (contents == null) {
            return;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes(StandardCharsets.ISO_8859_1));){
            this.properties.load(in);
        }
        catch (IOException e) {
            AnalysisContext.logError("Unable to load properties from " + contents, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPropertiesFromURL(URL url) {
        if (url == null) {
            return;
        }
        InputStream in = null;
        try {
            in = url.openStream();
            this.properties.load(in);
        }
        catch (IOException e) {
            AnalysisContext.logError("Unable to load properties from " + url, e);
        }
        finally {
            IO.close(in);
        }
    }

    public void loadProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String value = this.getProperty(name);
            if (value == null) {
                return defaultValue;
            }
            result = this.toBoolean(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    private boolean toBoolean(String name) {
        return name != null && "true".equalsIgnoreCase(name);
    }

    public int getInt(String name, int defaultValue) {
        try {
            String value = this.getProperty(name);
            if (value != null) {
                return Integer.decode(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public String getOSDependentProperty(String name) {
        String osDependentName = name + SystemProperties.OS_NAME;
        String value = this.getProperty(osDependentName);
        if (value != null) {
            return value;
        }
        return this.getProperty(name);
    }

    public String getProperty(String name) {
        try {
            String value = SystemProperties.getProperty(name);
            if (value != null) {
                return value;
            }
            return this.properties.getProperty(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public String toString() {
        return this.properties.toString();
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String rewriteURLAccordingToProperties(String u) {
        if (this.getRewriter().urlRewritePattern == null || this.getRewriter().urlRewriteFormat == null) {
            return u;
        }
        Matcher m = this.getRewriter().urlRewritePattern.matcher(u);
        if (!m.matches()) {
            return u;
        }
        String result = String.format(this.getRewriter().urlRewriteFormat, m.group(1));
        return result;
    }

    class Rewriter {
        private final String urlRewritePatternString;
        private final Pattern urlRewritePattern;
        private final String urlRewriteFormat;

        Rewriter() {
            this.urlRewritePatternString = PropertyBundle.this.getOSDependentProperty("findbugs.urlRewritePattern");
            this.urlRewriteFormat = PropertyBundle.this.getOSDependentProperty("findbugs.urlRewriteFormat");
            Pattern p = null;
            if (this.urlRewritePatternString != null && this.urlRewriteFormat != null) {
                try {
                    p = Pattern.compile(this.urlRewritePatternString);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.urlRewritePattern = p;
        }
    }
}

