/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.xml;

import edu.umd.cs.findbugs.xml.MetaCharacterMap;
import java.io.IOException;
import javax.annotation.Nonnull;

public abstract class QuoteMetaCharacters {
    private final String text;
    private final MetaCharacterMap map;

    public QuoteMetaCharacters(@Nonnull String text, @Nonnull MetaCharacterMap map) {
        if (text == null) {
            throw new NullPointerException("text must be nonnull");
        }
        if (map == null) {
            throw new NullPointerException("map must be nonnull");
        }
        this.text = text;
        this.map = map;
    }

    public void process() throws IOException {
        int pos = 0;
        do {
            int meta;
            if ((meta = this.findNextMeta(this.text, pos)) >= 0) {
                this.emitLiteral(this.text.substring(pos, meta));
                this.emitLiteral(this.map.getReplacement(this.text.substring(meta, meta + 1)));
                pos = meta + 1;
                continue;
            }
            this.emitLiteral(this.text.substring(pos, this.text.length()));
            pos = this.text.length();
        } while (pos < this.text.length());
    }

    public abstract void emitLiteral(String var1) throws IOException;

    private int findNextMeta(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!this.map.isMeta(c)) continue;
            return i;
        }
        return -1;
    }
}

