/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.jsr305.JSR305NullnessAnnotations;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.EnumValue;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.meta.TypeQualifier;
import javax.annotation.meta.TypeQualifierDefault;
import javax.annotation.meta.TypeQualifierNickname;

public class TypeQualifierResolver {
    static final ClassDescriptor typeQualifier = DescriptorFactory.createClassDescriptor(TypeQualifier.class);
    static final ClassDescriptor typeQualifierNickname = DescriptorFactory.createClassDescriptor(TypeQualifierNickname.class);
    static final ClassDescriptor typeQualifierDefault = DescriptorFactory.createClassDescriptor(TypeQualifierDefault.class);
    static final ClassDescriptor elementTypeDescriptor = DescriptorFactory.createClassDescriptor(ElementType.class);
    static final ClassDescriptor androidNullable = DescriptorFactory.createClassDescriptor("android/support/annotation/Nullable");
    static final ClassDescriptor androidNonNull = DescriptorFactory.createClassDescriptor("android/support/annotation/NonNull");
    static final ClassDescriptor googleNullable = DescriptorFactory.createClassDescriptor("com/google/common/base/Nullable");
    static final ClassDescriptor intellijNullable = DescriptorFactory.createClassDescriptor("org/jetbrains/annotations/Nullable");
    static final ClassDescriptor intellijNotNull = DescriptorFactory.createClassDescriptor("org/jetbrains/annotations/NotNull");
    static final ClassDescriptor eclipseNullable = DescriptorFactory.createClassDescriptor("org/eclipse/jdt/annotation/Nullable");
    static final ClassDescriptor eclipseNonNull = DescriptorFactory.createClassDescriptor("org/eclipse/jdt/annotation/NonNull");
    static final ClassDescriptor checkerFrameworkNullable = DescriptorFactory.createClassDescriptor("org/checkerframework/checker/nullness/qual/Nullable");
    static final ClassDescriptor checkerFrameworkNullableDecl = DescriptorFactory.createClassDescriptor("org/checkerframework/checker/nullness/compatqual/NullableDecl");
    static final ClassDescriptor eclipseNonNullByDefault = DescriptorFactory.createClassDescriptor("org/eclipse/jdt/annotation/NonNullByDefault");

    public static Collection<AnnotationValue> resolveTypeQualifiers(AnnotationValue value) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        TypeQualifierResolver.resolveTypeQualifierNicknames(value, result, new LinkedList<ClassDescriptor>());
        return result;
    }

    public static Collection<AnnotationValue> resolveTypeQualifierDefaults(Collection<AnnotationValue> values, ElementType elementType) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        for (AnnotationValue value : values) {
            TypeQualifierResolver.resolveTypeQualifierDefaults(value, elementType, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resolveTypeQualifierNicknames(AnnotationValue value, LinkedList<AnnotationValue> result, LinkedList<ClassDescriptor> onStack) {
        ClassDescriptor annotationClass = value.getAnnotationClass();
        if (onStack.contains(annotationClass)) {
            AnalysisContext.logError("Cycle found in type nicknames: " + onStack);
            return;
        }
        try {
            block16: {
                onStack.add(annotationClass);
                if (annotationClass.equals(androidNullable) || annotationClass.equals(googleNullable) || annotationClass.equals(eclipseNullable) || annotationClass.equals(intellijNullable) || annotationClass.equals(checkerFrameworkNullable) || annotationClass.equals(checkerFrameworkNullableDecl)) {
                    TypeQualifierResolver.resolveTypeQualifierNicknames(new AnnotationValue(JSR305NullnessAnnotations.CHECK_FOR_NULL), result, onStack);
                    return;
                }
                if (!annotationClass.equals(androidNonNull) && !annotationClass.equals(eclipseNonNull) && !annotationClass.equals(eclipseNonNullByDefault) && !annotationClass.equals(intellijNotNull)) break block16;
                TypeQualifierResolver.resolveTypeQualifierNicknames(new AnnotationValue(JSR305NullnessAnnotations.NONNULL), result, onStack);
                return;
            }
            try {
                XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, annotationClass);
                if (c.getAnnotationDescriptors().contains(typeQualifierNickname)) {
                    for (ClassDescriptor d : c.getAnnotationDescriptors()) {
                        if (d.equals(typeQualifierNickname)) continue;
                        TypeQualifierResolver.resolveTypeQualifierNicknames(c.getAnnotation(d), result, onStack);
                    }
                } else if (c.getAnnotationDescriptors().contains(typeQualifier)) {
                    result.add(value);
                }
            }
            catch (MissingClassException e) {
                TypeQualifierResolver.logMissingAnnotationClass(e);
                return;
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Error resolving " + annotationClass, e);
                return;
            }
        }
        finally {
            onStack.removeLast();
        }
    }

    public static void logMissingAnnotationClass(MissingClassException e) {
        ClassDescriptor c = e.getClassDescriptor();
        if (c.getClassName().startsWith("javax.annotation")) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(c);
        }
    }

    public static Collection<AnnotationValue> resolveTypeQualifiers(Collection<AnnotationValue> values) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        LinkedList<ClassDescriptor> onStack = new LinkedList<ClassDescriptor>();
        for (AnnotationValue value : values) {
            TypeQualifierResolver.resolveTypeQualifierNicknames(value, result, onStack);
        }
        return result;
    }

    private static void resolveTypeQualifierDefaults(AnnotationValue value, ElementType defaultFor, LinkedList<AnnotationValue> result) {
        try {
            XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, value.getAnnotationClass());
            AnnotationValue defaultAnnotation = c.getAnnotation(typeQualifierDefault);
            if (defaultAnnotation == null) {
                return;
            }
            for (Object o : (Object[])defaultAnnotation.getValue("value")) {
                if (!(o instanceof EnumValue)) continue;
                EnumValue e = (EnumValue)o;
                if (!e.desc.equals(elementTypeDescriptor) || !e.value.equals(defaultFor.name())) continue;
                for (ClassDescriptor d : c.getAnnotationDescriptors()) {
                    if (d.equals(typeQualifierDefault)) continue;
                    TypeQualifierResolver.resolveTypeQualifierNicknames(c.getAnnotation(d), result, new LinkedList<ClassDescriptor>());
                }
                break;
            }
        }
        catch (MissingClassException e) {
            TypeQualifierResolver.logMissingAnnotationClass(e);
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error resolving " + value.getAnnotationClass(), e);
        }
        catch (ClassCastException e) {
            AnalysisContext.logError("ClassCastException " + value.getAnnotationClass(), e);
        }
    }
}

