/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import java.util.BitSet;

public class BlockType
extends BitSet {
    private static final long serialVersionUID = 1L;
    private static final int PRIME = 31;
    public static final boolean CATCH = false;
    public static final boolean FINALLY = true;
    private boolean isValid;
    private boolean isTop;
    private int depth;

    BlockType() {
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.depth;
        result = 31 * result + (this.isTop ? 1231 : 1237);
        result = 31 * result + (this.isValid ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BlockType)) {
            return false;
        }
        BlockType other = (BlockType)obj;
        if (this.depth != other.depth) {
            return false;
        }
        if (this.isTop != other.isTop) {
            return false;
        }
        return this.isValid == other.isValid;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getDepth() {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        return this.depth;
    }

    public boolean getTopValue() {
        if (this.depth == 0) {
            throw new IllegalStateException();
        }
        return this.get(this.depth - 1);
    }

    public boolean isNormal() {
        if (!this.isValid) {
            throw new IllegalStateException();
        }
        return this.getDepth() == 0;
    }

    public void setNormal() {
        this.isValid = true;
        this.depth = 0;
    }

    public boolean isTop() {
        return !this.isValid && this.isTop;
    }

    public void setTop() {
        this.isValid = false;
        this.isTop = true;
    }

    public boolean isBottom() {
        return !this.isValid && !this.isTop;
    }

    public void setBottom() {
        this.isValid = false;
        this.isTop = false;
    }

    public void copyFrom(BlockType other) {
        this.isValid = other.isValid;
        this.isTop = other.isTop;
        if (this.isValid) {
            this.depth = other.depth;
            this.clear();
            this.or(other);
        }
    }

    public boolean sameAs(BlockType other) {
        if (!this.isValid) {
            return !other.isValid && this.isTop == other.isTop;
        }
        if (!other.isValid) {
            return false;
        }
        if (this.depth != other.depth) {
            return false;
        }
        for (int i = 0; i < this.depth; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public void mergeWith(BlockType other) {
        if (this.isTop() || other.isBottom()) {
            this.copyFrom(other);
        } else if (this.isValid()) {
            int commonLen;
            int pfxLen = Math.min(this.depth, other.depth);
            for (commonLen = 0; commonLen < pfxLen && this.get(commonLen) == other.get(commonLen); ++commonLen) {
            }
            this.depth = commonLen;
        }
    }

    public void pushCatch() {
        this.push(false);
    }

    public void pushFinally() {
        this.push(true);
    }

    @Override
    public String toString() {
        if (this.isTop()) {
            return "<top>";
        }
        if (this.isBottom()) {
            return "<bottom>";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("N");
        for (int i = 0; i < this.depth; ++i) {
            buf.append(!this.get(i) ? "C" : "F");
        }
        return buf.toString();
    }

    private void push(boolean value) {
        this.set(this.depth, value);
        ++this.depth;
    }
}

