/*
 * Decompiled with CFR 0.152.
 */
package japicmp.config;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import japicmp.cli.JApiCli;
import japicmp.cmp.JApiCmpArchive;
import japicmp.config.IgnoreMissingClasses;
import japicmp.exception.JApiCmpException;
import japicmp.filter.AnnotationBehaviorFilter;
import japicmp.filter.AnnotationClassFilter;
import japicmp.filter.AnnotationFieldFilter;
import japicmp.filter.Filter;
import japicmp.filter.JavaDocLikeClassFilter;
import japicmp.filter.JavadocLikeBehaviorFilter;
import japicmp.filter.JavadocLikeFieldFilter;
import japicmp.filter.JavadocLikePackageFilter;
import japicmp.model.AccessModifier;
import japicmp.util.Optional;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Options {
    private static final Logger LOGGER = Logger.getLogger(Options.class.getName());
    static final String N_A = "n.a.";
    private List<JApiCmpArchive> oldArchives = new ArrayList<JApiCmpArchive>();
    private List<JApiCmpArchive> newArchives = new ArrayList<JApiCmpArchive>();
    private boolean outputOnlyModifications = false;
    private boolean outputOnlyBinaryIncompatibleModifications = false;
    private Optional<String> xmlOutputFile = Optional.absent();
    private Optional<String> htmlOutputFile = Optional.absent();
    private Optional<AccessModifier> accessModifier = Optional.of(AccessModifier.PROTECTED);
    private List<Filter> includes = new ArrayList<Filter>();
    private List<Filter> excludes = new ArrayList<Filter>();
    private boolean includeSynthetic = false;
    private final IgnoreMissingClasses ignoreMissingClasses = new IgnoreMissingClasses();
    private Optional<String> htmlStylesheet = Optional.absent();
    private Optional<String> oldClassPath = Optional.absent();
    private Optional<String> newClassPath = Optional.absent();
    private JApiCli.ClassPathMode classPathMode = JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH;
    private boolean noAnnotations = false;
    private boolean reportOnlyFilename;
    private boolean semanticVersioning;
    private boolean errorOnBinaryIncompatibility;
    private boolean errorOnSourceIncompatibility;
    private boolean errorOnExclusionIncompatibility = true;
    private boolean errorOnModifications;
    private boolean errorOnSemanticIncompatibility;
    private boolean ignoreMissingOldVersion;
    private boolean ignoreMissingNewVersion;
    private boolean helpRequested;
    private boolean errorOnSemanticIncompatibilityForMajorVersionZero;

    Options() {
    }

    public static Options newDefault() {
        return new Options();
    }

    public void verify() {
        if (this.oldArchives.isEmpty()) {
            throw new JApiCmpException(JApiCmpException.Reason.CliError, "Required option -o, --old is missing.");
        }
        if (this.newArchives.isEmpty()) {
            throw new JApiCmpException(JApiCmpException.Reason.CliError, "Required option -n, --new is missing.");
        }
        for (JApiCmpArchive archive : this.getOldArchives()) {
            Options.verifyExistsCanReadAndJar(archive);
        }
        for (JApiCmpArchive archive : this.getNewArchives()) {
            Options.verifyExistsCanReadAndJar(archive);
        }
        if (this.getHtmlOutputFile().isPresent()) {
            String pathname;
            File stylesheetFile;
            if (this.getHtmlStylesheet().isPresent() && !(stylesheetFile = new File(pathname = this.getHtmlStylesheet().get())).exists()) {
                throw JApiCmpException.cliError("HTML stylesheet '%s' does not exist.", pathname);
            }
        } else if (this.getHtmlStylesheet().isPresent()) {
            throw JApiCmpException.cliError("Define a HTML output file, if you want to apply a stylesheet.", new Object[0]);
        }
        if (this.getOldClassPath().isPresent() && this.getNewClassPath().isPresent()) {
            this.setClassPathMode(JApiCli.ClassPathMode.TWO_SEPARATE_CLASSPATHS);
        } else {
            if (this.getOldClassPath().isPresent() || this.getNewClassPath().isPresent()) {
                throw JApiCmpException.cliError("Please provide both options: --old-classpath and --new-classpath", new Object[0]);
            }
            this.setClassPathMode(JApiCli.ClassPathMode.ONE_COMMON_CLASSPATH);
        }
    }

    private static void verifyExistsCanReadAndJar(JApiCmpArchive jApiCmpArchive) {
        Options.verifyExisting(jApiCmpArchive);
        Options.verifyCanRead(jApiCmpArchive);
        Options.verifyJarArchive(jApiCmpArchive);
    }

    private static void verifyExisting(JApiCmpArchive jApiCmpArchive) {
        if (!jApiCmpArchive.getFile().exists()) {
            throw JApiCmpException.cliError("File '%s' does not exist.", jApiCmpArchive.getFile().getAbsolutePath());
        }
    }

    private static void verifyCanRead(JApiCmpArchive jApiCmpArchive) {
        if (!jApiCmpArchive.getFile().canRead()) {
            throw JApiCmpException.cliError("Cannot read file '%s'.", jApiCmpArchive.getFile().getAbsolutePath());
        }
    }

    private static void verifyJarArchive(JApiCmpArchive jApiCmpArchive) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jApiCmpArchive.getFile());
        }
        catch (IOException e) {
            throw JApiCmpException.cliError("File '%s' could not be opened as a jar file: %s", jApiCmpArchive.getFile().getAbsolutePath(), e.getMessage(), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Failed to close file: " + e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public List<JApiCmpArchive> getNewArchives() {
        return this.newArchives;
    }

    public void setNewArchives(List<JApiCmpArchive> newArchives) {
        this.newArchives = newArchives;
    }

    public List<JApiCmpArchive> getOldArchives() {
        return this.oldArchives;
    }

    public void setOldArchives(List<JApiCmpArchive> oldArchives) {
        this.oldArchives = oldArchives;
    }

    public boolean isOutputOnlyModifications() {
        return this.outputOnlyModifications;
    }

    public void setOutputOnlyModifications(boolean outputOnlyModifications) {
        this.outputOnlyModifications = outputOnlyModifications;
    }

    public Optional<String> getXmlOutputFile() {
        return this.xmlOutputFile;
    }

    public void setXmlOutputFile(Optional<String> xmlOutputFile) {
        this.xmlOutputFile = xmlOutputFile;
    }

    public void setAccessModifier(Optional<AccessModifier> accessModifier) {
        this.accessModifier = accessModifier;
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier.get();
    }

    public void setAccessModifier(AccessModifier accessModifier) {
        this.accessModifier = Optional.of(accessModifier);
    }

    public List<Filter> getIncludes() {
        return ImmutableList.copyOf(this.includes);
    }

    public List<Filter> getExcludes() {
        return ImmutableList.copyOf(this.excludes);
    }

    public void addExcludeFromArgument(Optional<String> packagesExcludeArg, boolean excludeExclusively) {
        this.excludes = this.createFilterList(packagesExcludeArg, this.excludes, "Wrong syntax for exclude option '%s': %s", excludeExclusively);
    }

    public void addIncludeFromArgument(Optional<String> packagesIncludeArg, boolean includeExclusively) {
        this.includes = this.createFilterList(packagesIncludeArg, this.includes, "Wrong syntax for include option '%s': %s", includeExclusively);
    }

    public List<Filter> createFilterList(Optional<String> argumentString, List<Filter> filters, String errorMessage, boolean exclusive) {
        for (String filterString : Splitter.on((String)";").trimResults().omitEmptyStrings().split((CharSequence)argumentString.or(""))) {
            try {
                if (filterString.startsWith("@")) {
                    filters.add(new AnnotationClassFilter(filterString));
                    filters.add(new AnnotationFieldFilter(filterString));
                    filters.add(new AnnotationBehaviorFilter(filterString));
                }
                if (filterString.contains("#")) {
                    if (filterString.contains("(")) {
                        JavadocLikeBehaviorFilter behaviorFilter = new JavadocLikeBehaviorFilter(filterString);
                        filters.add(behaviorFilter);
                        continue;
                    }
                    JavadocLikeFieldFilter fieldFilter = new JavadocLikeFieldFilter(filterString);
                    filters.add(fieldFilter);
                    continue;
                }
                JavaDocLikeClassFilter classFilter = new JavaDocLikeClassFilter(filterString);
                filters.add(classFilter);
                JavadocLikePackageFilter packageFilter = new JavadocLikePackageFilter(filterString, exclusive);
                filters.add(packageFilter);
            }
            catch (Exception e) {
                throw new JApiCmpException(JApiCmpException.Reason.CliError, String.format(errorMessage, filterString, e.getMessage()), e);
            }
        }
        return filters;
    }

    public boolean isOutputOnlyBinaryIncompatibleModifications() {
        return this.outputOnlyBinaryIncompatibleModifications;
    }

    public void setOutputOnlyBinaryIncompatibleModifications(boolean outputOnlyBinaryIncompatibleModifications) {
        this.outputOnlyBinaryIncompatibleModifications = outputOnlyBinaryIncompatibleModifications;
    }

    public Optional<String> getHtmlOutputFile() {
        return this.htmlOutputFile;
    }

    public void setHtmlOutputFile(Optional<String> htmlOutputFile) {
        this.htmlOutputFile = htmlOutputFile;
    }

    public boolean isIncludeSynthetic() {
        return this.includeSynthetic;
    }

    public void setIncludeSynthetic(boolean showSynthetic) {
        this.includeSynthetic = showSynthetic;
    }

    public void setIgnoreMissingClasses(boolean ignoreMissingClasses) {
        this.ignoreMissingClasses.setIgnoreAllMissingClasses(ignoreMissingClasses);
    }

    public Optional<String> getHtmlStylesheet() {
        return this.htmlStylesheet;
    }

    public void setHtmlStylesheet(Optional<String> htmlStylesheet) {
        this.htmlStylesheet = htmlStylesheet;
    }

    public Optional<String> getOldClassPath() {
        return this.oldClassPath;
    }

    public void setOldClassPath(Optional<String> oldClassPath) {
        this.oldClassPath = oldClassPath;
    }

    public Optional<String> getNewClassPath() {
        return this.newClassPath;
    }

    public void setNewClassPath(Optional<String> newClassPath) {
        this.newClassPath = newClassPath;
    }

    public JApiCli.ClassPathMode getClassPathMode() {
        return this.classPathMode;
    }

    public void setClassPathMode(JApiCli.ClassPathMode classPathMode) {
        this.classPathMode = classPathMode;
    }

    public boolean isNoAnnotations() {
        return this.noAnnotations;
    }

    public void setNoAnnotations(boolean noAnnotations) {
        this.noAnnotations = noAnnotations;
    }

    public void addIgnoreMissingClassRegularExpression(String missingClassRegEx) {
        try {
            Pattern pattern = Pattern.compile(missingClassRegEx);
            this.ignoreMissingClasses.getIgnoreMissingClassRegularExpression().add(pattern);
        }
        catch (Exception e) {
            throw new JApiCmpException(JApiCmpException.Reason.IllegalArgument, "Could not compile provided regular expression: " + e.getMessage(), e);
        }
    }

    public IgnoreMissingClasses getIgnoreMissingClasses() {
        return this.ignoreMissingClasses;
    }

    public void setReportOnlyFilename(boolean reportOnlyFilename) {
        this.reportOnlyFilename = reportOnlyFilename;
    }

    public String getDifferenceDescription() {
        Joiner joiner = Joiner.on((String)";");
        StringBuilder sb = new StringBuilder().append("Comparing ").append(this.isOutputOnlyBinaryIncompatibleModifications() ? "binary" : "source").append(" compatibility of ");
        sb.append(joiner.join(this.toPathList(this.newArchives)));
        sb.append(" against ");
        sb.append(joiner.join(this.toPathList(this.oldArchives)));
        return sb.toString();
    }

    private List<String> toPathList(List<JApiCmpArchive> archives) {
        ArrayList<String> paths = new ArrayList<String>(archives.size());
        for (JApiCmpArchive archive : archives) {
            if (this.reportOnlyFilename) {
                paths.add(archive.getFile().getName());
                continue;
            }
            paths.add(archive.getFile().getAbsolutePath());
        }
        return paths;
    }

    private List<String> toVersionList(List<JApiCmpArchive> archives) {
        ArrayList<String> versions = new ArrayList<String>(archives.size());
        for (JApiCmpArchive archive : archives) {
            String stringVersion = archive.getVersion().getStringVersion();
            if (stringVersion == null) continue;
            versions.add(stringVersion);
        }
        return versions;
    }

    public String joinOldArchives() {
        Joiner joiner = Joiner.on((String)";");
        String join = joiner.join(this.toPathList(this.oldArchives));
        if (join.trim().length() == 0) {
            return N_A;
        }
        return join;
    }

    public String joinNewArchives() {
        Joiner joiner = Joiner.on((String)";");
        String join = joiner.join(this.toPathList(this.newArchives));
        if (join.trim().length() == 0) {
            return N_A;
        }
        return join;
    }

    public String joinOldVersions() {
        Joiner joiner = Joiner.on((String)";");
        String join = joiner.join(this.toVersionList(this.oldArchives));
        if (join.trim().length() == 0) {
            return N_A;
        }
        return join;
    }

    public String joinNewVersions() {
        Joiner joiner = Joiner.on((String)";");
        String join = joiner.join(this.toVersionList(this.newArchives));
        if (join.trim().length() == 0) {
            return N_A;
        }
        return join;
    }

    public void setSemanticVersioning(boolean semanticVersioning) {
        this.semanticVersioning = semanticVersioning;
    }

    public boolean isSemanticVersioning() {
        return this.semanticVersioning;
    }

    public boolean isErrorOnBinaryIncompatibility() {
        return this.errorOnBinaryIncompatibility;
    }

    public void setErrorOnBinaryIncompatibility(boolean errorOnBinaryIncompatibility) {
        this.errorOnBinaryIncompatibility = errorOnBinaryIncompatibility;
    }

    public boolean isErrorOnSourceIncompatibility() {
        return this.errorOnSourceIncompatibility;
    }

    public void setErrorOnSourceIncompatibility(boolean errorOnSourceIncompatibility) {
        this.errorOnSourceIncompatibility = errorOnSourceIncompatibility;
    }

    public boolean isErrorOnExclusionIncompatibility() {
        return this.errorOnExclusionIncompatibility;
    }

    public void setErrorOnExclusionIncompatibility(boolean errorOnExclusionIncompatibility) {
        this.errorOnExclusionIncompatibility = errorOnExclusionIncompatibility;
    }

    public boolean isErrorOnModifications() {
        return this.errorOnModifications;
    }

    public void setErrorOnModifications(boolean errorOnModifications) {
        this.errorOnModifications = errorOnModifications;
    }

    public boolean isErrorOnSemanticIncompatibility() {
        return this.errorOnSemanticIncompatibility;
    }

    public void setErrorOnSemanticIncompatibility(boolean errorOnSemanticIncompatibility) {
        this.errorOnSemanticIncompatibility = errorOnSemanticIncompatibility;
    }

    public boolean isIgnoreMissingOldVersion() {
        return this.ignoreMissingOldVersion;
    }

    public void setIgnoreMissingOldVersion(boolean ignoreMissingOldVersion) {
        this.ignoreMissingOldVersion = ignoreMissingOldVersion;
    }

    public boolean isIgnoreMissingNewVersion() {
        return this.ignoreMissingNewVersion;
    }

    public void setIgnoreMissingNewVersion(boolean ignoreMissingNewVersion) {
        this.ignoreMissingNewVersion = ignoreMissingNewVersion;
    }

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    public void setHelpRequested(boolean helpRequested) {
        this.helpRequested = helpRequested;
    }

    public boolean isErrorOnSemanticIncompatibilityForMajorVersionZero() {
        return this.errorOnSemanticIncompatibilityForMajorVersionZero;
    }

    public void setErrorOnSemanticIncompatibilityForMajorVersionZero(boolean errorOnSemanticIncompatibilityForMajorVersionZero) {
        this.errorOnSemanticIncompatibilityForMajorVersionZero = errorOnSemanticIncompatibilityForMajorVersionZero;
    }
}

