/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.EntityDetails;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequest;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpVersion;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.Method;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ProtocolException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ProtocolVersion;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.net.URIAuthority;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        ProtocolVersion ver = context.getProtocolVersion();
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method) && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            URIAuthority authority = request.getAuthority();
            if (authority == null) {
                if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                    return;
                }
                throw new ProtocolException("Target host is unknown");
            }
            if (authority.getUserInfo() != null) {
                authority = new URIAuthority(authority.getHostName(), authority.getPort());
            }
            request.addHeader("Host", authority);
        }
    }
}

