/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.auth;

import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.ECSMetadataServiceCredentialsFetcher;
import com.aliyuncs.auth.InstanceProfileCredentials;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.utils.AuthUtils;

public class InstanceProfileCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private static final int MAX_ECS_METADATA_FETCH_RETRY_TIMES = 3;
    private final String roleName;
    public int ecsMetadataServiceFetchCount = 0;
    private InstanceProfileCredentials credentials = null;
    private ECSMetadataServiceCredentialsFetcher fetcher;

    public InstanceProfileCredentialsProvider(String roleName) {
        if (null == roleName) {
            throw new NullPointerException("You must specify a valid role name.");
        }
        this.roleName = roleName;
        this.fetcher = new ECSMetadataServiceCredentialsFetcher();
        this.fetcher.setRoleName(this.roleName);
    }

    public InstanceProfileCredentialsProvider withFetcher(ECSMetadataServiceCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        this.fetcher.setRoleName(this.roleName);
        return this;
    }

    private InstanceProfileCredentialsProvider(BuilderImpl builder) {
        if (AuthUtils.isDisableECSMetaData()) {
            throw new IllegalArgumentException("IMDS credentials is disabled.");
        }
        this.roleName = builder.roleName == null ? AuthUtils.getEnvironmentECSMetaData() : builder.roleName;
        boolean disableIMDSv1 = builder.disableIMDSv1 == null ? AuthUtils.getDisableECSIMDSv1() : builder.disableIMDSv1;
        this.fetcher = new ECSMetadataServiceCredentialsFetcher(this.roleName, disableIMDSv1, builder.connectionTimeout, builder.readTimeout);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException {
        if (this.credentials == null || this.credentials.isExpired()) {
            ++this.ecsMetadataServiceFetchCount;
            this.credentials = this.fetcher.fetch(3);
        } else if (this.credentials.willSoonExpire() && this.credentials.shouldRefresh()) {
            try {
                ++this.ecsMetadataServiceFetchCount;
                this.credentials = this.fetcher.fetch();
            }
            catch (ClientException e) {
                this.credentials.setLastFailedRefreshTime();
            }
        }
        return this.credentials;
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleName;
        private Boolean disableIMDSv1;
        private Integer connectionTimeout;
        private Integer readTimeout;

        private BuilderImpl() {
        }

        @Override
        public Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        @Override
        public Builder disableIMDSv1(Boolean disableIMDSv1) {
            this.disableIMDSv1 = disableIMDSv1;
            return this;
        }

        @Override
        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Override
        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public InstanceProfileCredentialsProvider build() {
            return new InstanceProfileCredentialsProvider(this);
        }
    }

    public static interface Builder {
        public Builder roleName(String var1);

        public Builder disableIMDSv1(Boolean var1);

        public Builder connectionTimeout(Integer var1);

        public Builder readTimeout(Integer var1);

        public InstanceProfileCredentialsProvider build();
    }
}

