/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http;

import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUtil {
    private static final Log log;
    private static Boolean isHttpDebug;
    private static Boolean isHttpContentDebug;

    public static Boolean getIsHttpDebug() {
        return isHttpDebug;
    }

    public static void setIsHttpDebug(Boolean isHttpDebug) {
        HttpUtil.isHttpDebug = isHttpDebug;
    }

    public static Boolean getIsHttpContentDebug() {
        return isHttpContentDebug;
    }

    public static void setIsHttpContentDebug(Boolean isHttpContentDebug) {
        HttpUtil.isHttpContentDebug = isHttpContentDebug;
    }

    public static String debugHttpRequest(HttpRequest request) throws ClientException {
        if (isHttpDebug.booleanValue()) {
            String protocol = request.getSysUrl().split("://")[0].toUpperCase() + "/1.1";
            StringBuilder debugString = new StringBuilder("> " + (Object)((Object)request.getSysMethod()) + " " + protocol + "\n> ");
            Map<String, String> requestHeaders = request.getSysHeaders();
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                debugString.append(entry.getKey() + " : " + entry.getValue() + "\n> ");
            }
            if (isHttpContentDebug.booleanValue()) {
                debugString.append("\n" + request.getHttpContentString());
            }
            log.info((Object)("\n" + debugString));
            return debugString.toString();
        }
        return null;
    }

    public static String debugHttpResponse(HttpResponse response) throws ClientException {
        if (isHttpDebug.booleanValue()) {
            String protocol = "HTTP/1.1";
            StringBuilder debugString = new StringBuilder("< " + protocol + " " + response.getStatus() + "\n< ");
            Map<String, String> responseHeaders = response.getSysHeaders();
            for (Map.Entry<String, String> entry : responseHeaders.entrySet()) {
                debugString.append(entry.getKey() + " : " + entry.getValue() + "\n< ");
            }
            if (isHttpContentDebug.booleanValue()) {
                debugString.append("\n" + response.getHttpContentString());
            }
            log.info((Object)("\n" + debugString));
            return debugString.toString();
        }
        return null;
    }

    static {
        Boolean flag;
        log = LogFactory.getLog(HttpUtil.class);
        isHttpDebug = flag = Boolean.valueOf("sdk".equalsIgnoreCase(System.getenv("DEBUG")));
        isHttpContentDebug = flag;
    }
}

