/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class QueryPushRecordsRequest
extends Request {
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="EndTime")
    @Validation(required=true)
    private String endTime;
    @Query
    @NameInMap(value="Keyword")
    private String keyword;
    @Query
    @NameInMap(value="NextToken")
    private String nextToken;
    @Query
    @NameInMap(value="Page")
    @Validation(maximum=10000.0, minimum=1.0)
    private Integer page;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=100.0, minimum=1.0)
    private Integer pageSize;
    @Query
    @NameInMap(value="PushType")
    private String pushType;
    @Query
    @NameInMap(value="Source")
    private String source;
    @Query
    @NameInMap(value="StartTime")
    @Validation(required=true)
    private String startTime;
    @Query
    @NameInMap(value="Target")
    private String target;

    private QueryPushRecordsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appKey = builder.appKey;
        this.endTime = builder.endTime;
        this.keyword = builder.keyword;
        this.nextToken = builder.nextToken;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.pushType = builder.pushType;
        this.source = builder.source;
        this.startTime = builder.startTime;
        this.target = builder.target;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static QueryPushRecordsRequest create() {
        return QueryPushRecordsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getPushType() {
        return this.pushType;
    }

    public String getSource() {
        return this.source;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getTarget() {
        return this.target;
    }

    public static final class Builder
    extends Request.Builder<QueryPushRecordsRequest, Builder> {
        private Long appKey;
        private String endTime;
        private String keyword;
        private String nextToken;
        private Integer page;
        private Integer pageSize;
        private String pushType;
        private String source;
        private String startTime;
        private String target;

        private Builder() {
        }

        private Builder(QueryPushRecordsRequest request) {
            super((Request)request);
            this.appKey = request.appKey;
            this.endTime = request.endTime;
            this.keyword = request.keyword;
            this.nextToken = request.nextToken;
            this.page = request.page;
            this.pageSize = request.pageSize;
            this.pushType = request.pushType;
            this.source = request.source;
            this.startTime = request.startTime;
            this.target = request.target;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder endTime(String endTime) {
            this.putQueryParameter("EndTime", endTime);
            this.endTime = endTime;
            return this;
        }

        public Builder keyword(String keyword) {
            this.putQueryParameter("Keyword", keyword);
            this.keyword = keyword;
            return this;
        }

        public Builder nextToken(String nextToken) {
            this.putQueryParameter("NextToken", nextToken);
            this.nextToken = nextToken;
            return this;
        }

        public Builder page(Integer page) {
            this.putQueryParameter("Page", page);
            this.page = page;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder pushType(String pushType) {
            this.putQueryParameter("PushType", pushType);
            this.pushType = pushType;
            return this;
        }

        public Builder source(String source) {
            this.putQueryParameter("Source", source);
            this.source = source;
            return this;
        }

        public Builder startTime(String startTime) {
            this.putQueryParameter("StartTime", startTime);
            this.startTime = startTime;
            return this;
        }

        public Builder target(String target) {
            this.putQueryParameter("Target", target);
            this.target = target;
            return this;
        }

        public QueryPushRecordsRequest build() {
            return new QueryPushRecordsRequest(this);
        }
    }
}

