/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.push20160801.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class BindAliasRequest
extends Request {
    @Query
    @NameInMap(value="AliasName")
    @Validation(required=true)
    private String aliasName;
    @Query
    @NameInMap(value="AppKey")
    @Validation(required=true)
    private Long appKey;
    @Query
    @NameInMap(value="DeviceId")
    @Validation(required=true)
    private String deviceId;

    private BindAliasRequest(Builder builder) {
        super((Request.Builder)builder);
        this.aliasName = builder.aliasName;
        this.appKey = builder.appKey;
        this.deviceId = builder.deviceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BindAliasRequest create() {
        return BindAliasRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public Long getAppKey() {
        return this.appKey;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public static final class Builder
    extends Request.Builder<BindAliasRequest, Builder> {
        private String aliasName;
        private Long appKey;
        private String deviceId;

        private Builder() {
        }

        private Builder(BindAliasRequest request) {
            super((Request)request);
            this.aliasName = request.aliasName;
            this.appKey = request.appKey;
            this.deviceId = request.deviceId;
        }

        public Builder aliasName(String aliasName) {
            this.putQueryParameter("AliasName", aliasName);
            this.aliasName = aliasName;
            return this;
        }

        public Builder appKey(Long appKey) {
            this.putQueryParameter("AppKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.putQueryParameter("DeviceId", deviceId);
            this.deviceId = deviceId;
            return this;
        }

        public BindAliasRequest build() {
            return new BindAliasRequest(this);
        }
    }
}

