/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ons.open.trace.core.utils;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingSerializable;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class MixUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            block5: while (true) {
                if (!enumeration.hasMoreElements()) {
                    if (!ipv4Result.isEmpty()) {
                        String ip;
                        Iterator i$ = ipv4Result.iterator();
                        do {
                            if (i$.hasNext()) continue;
                            return (String)ipv4Result.get(ipv4Result.size() - 1);
                        } while ((ip = (String)i$.next()).startsWith("127.0") || ip.startsWith("192.168"));
                        return ip;
                    }
                    if (!ipv6Result.isEmpty()) {
                        return (String)ipv6Result.get(0);
                    }
                    InetAddress localHost = InetAddress.getLocalHost();
                    return MixUtils.normalizeHostAddress(localHost);
                }
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                while (true) {
                    if (!en.hasMoreElements()) continue block5;
                    InetAddress address = en.nextElement();
                    if (address.isLoopbackAddress()) continue;
                    if (address instanceof Inet6Address) {
                        ipv6Result.add(MixUtils.normalizeHostAddress(address));
                        continue;
                    }
                    ipv4Result.add(MixUtils.normalizeHostAddress(address));
                }
                break;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    public static String toJson(Object obj, boolean prettyFormat) {
        return RemotingSerializable.toJson(obj, prettyFormat);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return RemotingSerializable.fromJson(json, classOfT);
    }

    public static String replaceNull(String ori) {
        return ori == null ? "" : ori;
    }
}

