/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.util.windows.structures;

import org.xvolks.jnative.JNative;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.misc.basicStructures.DWORD;
import org.xvolks.jnative.misc.basicStructures.HANDLE;
import org.xvolks.jnative.misc.basicStructures.LONG;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.pointers.memory.MemoryBlockFactory;
import org.xvolks.jnative.util.windows.structures.DEV_BROADCAST_HDR;
import org.xvolks.jnative.util.windows.structures.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DEV_BROADCAST_HANDLE
extends DEV_BROADCAST_HDR<DEV_BROADCAST_HANDLE> {
    private HANDLE dbch_handle = new HANDLE(0);
    private HANDLE dbch_hdevnotify = new HANDLE(0);
    private LONG dbch_nameoffset = new LONG(0);
    private GUID dbch_eventguid = new GUID();
    private LONG dbch_data = new LONG(0);

    public DEV_BROADCAST_HANDLE(Pointer pointer) {
        super(pointer);
        try {
            this.dbch_eventguid = new GUID();
            this.getValueFromPointer();
        }
        catch (NativeException e) {
            e.printStackTrace();
        }
    }

    public DEV_BROADCAST_HANDLE(int DBT_DEVTYP, GUID guid) {
        this.dbch_devicetype = new DWORD(DBT_DEVTYP);
        this.dbch_eventguid = new GUID(guid);
        try {
            this.createPointer();
            int offset = 0;
            offset += this.pointer.setIntAt(offset, this.dbch_size.getValue());
            offset += this.pointer.setIntAt(offset, this.dbch_devicetype.getValue());
            offset += this.pointer.setIntAt(offset, this.dbch_reserved.getValue());
            offset += this.pointer.setIntAt(offset, this.dbch_handle.getValue());
            offset += this.pointer.setIntAt(offset, this.dbch_hdevnotify.getValue());
            Pointer pointerOrg = this.dbch_eventguid.getPointer();
            for (int i = 0; i < 16; ++i) {
                byte asByte = pointerOrg.getAsByte(i);
                JNative.getLogger().log("GUID(" + i + ") = " + Integer.toHexString(asByte & 0xFF));
                this.pointer.setByteAt(offset++, asByte);
            }
            offset += this.pointer.setIntAt(offset, this.dbch_nameoffset.getValue());
            offset += this.pointer.setByteAt(offset, this.dbch_data.getValue().byteValue());
        }
        catch (NativeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Pointer createPointer() throws NativeException {
        this.pointer = new Pointer(MemoryBlockFactory.createMemoryBlock(this.getSizeOf()));
        return this.pointer;
    }

    public static int getSize() {
        return 41;
    }

    @Override
    public int getSizeOf() {
        return this.dbch_size.getValue();
    }

    @Override
    public DEV_BROADCAST_HANDLE getValueFromPointer() throws NativeException {
        this.offset = 0;
        super.getValueFromPointer();
        this.dbch_handle.setValue(this.getNextInt());
        this.dbch_hdevnotify.setValue(this.getNextInt());
        this.dbch_eventguid.setValue(this.pointer.getMemory(), this.offset);
        this.offset += 16;
        this.dbch_nameoffset.setValue(this.getNextInt());
        this.dbch_data.setValue(this.getNextByte());
        return this;
    }

    @Override
    public DEV_BROADCAST_HANDLE getValue() {
        return this;
    }

    public HANDLE getDbch_handle() {
        return this.dbch_handle;
    }

    public HANDLE getDbch_hdevnotify() {
        return this.dbch_hdevnotify;
    }

    public GUID getDbch_eventguid() {
        return this.dbch_eventguid;
    }

    public LONG getDbch_nameoffset() {
        return this.dbch_nameoffset;
    }

    public LONG getDbch_data() {
        return this.dbch_data;
    }
}

