/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.domain;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.UUID;

public enum ClickHouseDataType {
    IntervalYear(4, Integer.class, true, 19, 0, new String[0]),
    IntervalQuarter(4, Integer.class, true, 19, 0, new String[0]),
    IntervalMonth(4, Integer.class, true, 19, 0, new String[0]),
    IntervalWeek(4, Integer.class, true, 19, 0, new String[0]),
    IntervalDay(4, Integer.class, true, 19, 0, new String[0]),
    IntervalHour(4, Integer.class, true, 19, 0, new String[0]),
    IntervalMinute(4, Integer.class, true, 19, 0, new String[0]),
    IntervalSecond(4, Integer.class, true, 19, 0, new String[0]),
    UInt64(-5, BigInteger.class, false, 19, 0, new String[0]),
    UInt32(4, Long.class, false, 10, 0, new String[0]),
    UInt16(5, Integer.class, false, 5, 0, new String[0]),
    UInt8(-6, Integer.class, false, 3, 0, new String[0]),
    Int64(-5, Long.class, true, 20, 0, "BIGINT"),
    Int32(4, Integer.class, true, 11, 0, "INTEGER", "INT"),
    Int16(5, Integer.class, true, 6, 0, "SMALLINT"),
    Int8(-6, Integer.class, true, 4, 0, "TINYINT"),
    Date(91, Date.class, false, 10, 0, new String[0]),
    DateTime(93, Timestamp.class, false, 19, 0, "TIMESTAMP"),
    Enum8(12, String.class, false, 0, 0, new String[0]),
    Enum16(12, String.class, false, 0, 0, new String[0]),
    Float32(6, Float.class, true, 8, 8, "FLOAT"),
    Float64(8, Double.class, true, 17, 17, "DOUBLE"),
    Decimal32(3, BigDecimal.class, true, 9, 9, new String[0]),
    Decimal64(3, BigDecimal.class, true, 18, 18, new String[0]),
    Decimal128(3, BigDecimal.class, true, 38, 38, new String[0]),
    Decimal(3, BigDecimal.class, true, 0, 0, "DEC"),
    UUID(1111, UUID.class, false, 36, 0, new String[0]),
    String(12, String.class, false, 0, 0, "LONGBLOB", "MEDIUMBLOB", "TINYBLOB", "MEDIUMTEXT", "CHAR", "VARCHAR", "TEXT", "TINYTEXT", "LONGTEXT", "BLOB"),
    FixedString(1, String.class, false, -1, 0, "BINARY"),
    Nothing(0, Object.class, false, 0, 0, new String[0]),
    Nested(2002, String.class, false, 0, 0, new String[0]),
    Tuple(1111, String.class, false, 0, 0, new String[0]),
    Array(2003, Array.class, false, 0, 0, new String[0]),
    AggregateFunction(1111, String.class, false, 0, 0, new String[0]),
    Unknown(1111, String.class, false, 0, 0, new String[0]);

    private final int sqlType;
    private final Class<?> javaClass;
    private final boolean signed;
    private final int defaultPrecision;
    private final int defaultScale;
    private final String[] aliases;

    private ClickHouseDataType(int sqlType, Class<?> javaClass, boolean signed, int defaultPrecision, int defaultScale, String ... aliases) {
        this.sqlType = sqlType;
        this.javaClass = javaClass;
        this.signed = signed;
        this.defaultPrecision = defaultPrecision;
        this.defaultScale = defaultScale;
        this.aliases = aliases;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getDefaultPrecision() {
        return this.defaultPrecision;
    }

    public int getDefaultScale() {
        return this.defaultScale;
    }

    public static ClickHouseDataType fromTypeString(String typeString) {
        String s = typeString.trim();
        for (ClickHouseDataType dataType : ClickHouseDataType.values()) {
            if (s.equalsIgnoreCase(dataType.name())) {
                return dataType;
            }
            for (String alias : dataType.aliases) {
                if (!s.equalsIgnoreCase(alias)) continue;
                return dataType;
            }
        }
        return Unknown;
    }

    public static ClickHouseDataType resolveDefaultArrayDataType(String typeName) {
        for (ClickHouseDataType chDataType : ClickHouseDataType.values()) {
            if (!chDataType.name().equals(typeName)) continue;
            return chDataType;
        }
        return String;
    }
}

