/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.sonarsource.scanner.maven.bootstrap.MavenPlugin;

public final class MavenUtils {
    private static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    public static final String GROUP_ID_APACHE_MAVEN = "org.apache.maven.plugins";
    public static final String GROUP_ID_CODEHAUS_MOJO = "org.codehaus.mojo";

    private MavenUtils() {
    }

    @CheckForNull
    public static String getJavaVersion(MavenProject pom) {
        return MavenUtils.getPluginSetting(pom, GROUP_ID_APACHE_MAVEN, MAVEN_COMPILER_PLUGIN, "target", null);
    }

    @CheckForNull
    public static String getJavaSourceVersion(MavenProject pom) {
        return MavenUtils.getPluginSetting(pom, GROUP_ID_APACHE_MAVEN, MAVEN_COMPILER_PLUGIN, "source", null);
    }

    @CheckForNull
    public static String getSourceEncoding(MavenProject pom) {
        return pom.getProperties().getProperty("project.build.sourceEncoding");
    }

    public static String getPluginSetting(MavenProject project, String groupId, String artifactId, String optionName, @Nullable String defaultValue) {
        MavenPlugin plugin = MavenPlugin.getPlugin(project, groupId, artifactId);
        if (plugin != null) {
            return StringUtils.defaultIfEmpty((String)plugin.getParameter(optionName), (String)defaultValue);
        }
        return defaultValue;
    }
}

