/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.authentication;

import io.netty.util.CharsetUtil;
import io.r2dbc.postgresql.util.Assert;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import reactor.core.Exceptions;

final class FluentMessageDigest {
    private final MessageDigest messageDigest;

    FluentMessageDigest(String algorithm) {
        Assert.requireNonNull(algorithm, "algorithm must not be null");
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    String digest() {
        return String.format("%032x", new BigInteger(1, this.messageDigest.digest()));
    }

    FluentMessageDigest update(String s) {
        Assert.requireNonNull(s, "s must not be null");
        this.messageDigest.update(s.getBytes(CharsetUtil.UTF_8));
        return this;
    }

    FluentMessageDigest update(String format, Object ... args) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(args, "args must not be null");
        return this.update(String.format(format, args));
    }

    FluentMessageDigest update(ByteBuffer buffer) {
        Assert.requireNonNull(buffer, "buffer must not be null");
        this.messageDigest.update(buffer);
        return this;
    }
}

