/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.r2dbc.postgresql.client.AbstractPostgresSSLHandlerAdapter;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.message.frontend.SSLRequest;
import reactor.core.publisher.Mono;

final class SSLSessionHandlerAdapter
extends AbstractPostgresSSLHandlerAdapter {
    private final ByteBufAllocator alloc;
    private final SSLConfig sslConfig;

    SSLSessionHandlerAdapter(ByteBufAllocator alloc, SSLConfig sslConfig) {
        super(alloc, sslConfig);
        this.alloc = alloc;
        this.sslConfig = sslConfig;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        Mono.from(SSLRequest.INSTANCE.encode(this.alloc)).subscribe(arg_0 -> ((ChannelHandlerContext)ctx).writeAndFlush(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf buf = (ByteBuf)msg;
        char response = (char)buf.readByte();
        try {
            switch (response) {
                case 'S': {
                    this.processSslEnabled(ctx, buf);
                    return;
                }
                case 'N': {
                    this.processSslDisabled();
                    return;
                }
                default: {
                    buf.release();
                    throw new IllegalStateException("Unknown SSLResponse from server: '" + response + "'");
                }
            }
        }
        finally {
            buf.release();
        }
    }

    private void processSslDisabled() {
        if (this.sslConfig.getSslMode().requireSsl()) {
            AbstractPostgresSSLHandlerAdapter.PostgresqlSslException e = new AbstractPostgresSSLHandlerAdapter.PostgresqlSslException("Server support for SSL connection is disabled, but client was configured with SSL mode " + (Object)((Object)this.sslConfig.getSslMode()));
            this.completeHandshakeExceptionally((Throwable)((Object)e));
        } else {
            this.completeHandshake();
        }
    }

    private void processSslEnabled(ChannelHandlerContext ctx, ByteBuf msg) {
        if (this.sslConfig.getSslMode() == SSLMode.DISABLE) {
            AbstractPostgresSSLHandlerAdapter.PostgresqlSslException e = new AbstractPostgresSSLHandlerAdapter.PostgresqlSslException("Server requires SSL handshake, but client was configured with SSL mode DISABLE");
            this.completeHandshakeExceptionally((Throwable)((Object)e));
            return;
        }
        ctx.channel().pipeline().addFirst(new ChannelHandler[]{this.getSslHandler()}).remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)msg.retain());
    }
}

