/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.LogLevel;
import java.time.Duration;
import java.util.function.Consumer;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.util.annotation.Nullable;

public final class ConnectionSettings {
    @Nullable
    private final Duration connectTimeout;
    private final ConnectionProvider connectionProvider;
    @Nullable
    private final LoopResources loopResources;
    private final SSLConfig sslConfig;
    private final boolean tcpKeepAlive;
    private final boolean tcpNoDelay;
    private final LogLevel errorResponseLogLevel;
    private final LogLevel noticeLogLevel;

    ConnectionSettings(@Nullable Duration connectTimeout, ConnectionProvider connectionProvider, @Nullable LoopResources loopResources, SSLConfig sslConfig, boolean tcpKeepAlive, boolean tcpNoDelay, LogLevel errorResponseLogLevel, LogLevel noticeLogLevel) {
        this.connectTimeout = connectTimeout;
        this.connectionProvider = connectionProvider;
        this.loopResources = loopResources;
        this.sslConfig = sslConfig;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.errorResponseLogLevel = errorResponseLogLevel;
        this.noticeLogLevel = noticeLogLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder mutate() {
        return new Builder().connectionProvider(this.connectionProvider).loopResources(this.loopResources).errorResponseLogLevel(this.errorResponseLogLevel).noticeLogLevel(this.noticeLogLevel).sslConfig(this.sslConfig).connectTimeout(this.connectTimeout).tcpKeepAlive(this.tcpKeepAlive).tcpNoDelay(this.tcpNoDelay);
    }

    public ConnectionSettings mutate(Consumer<Builder> mutator) {
        Builder builder = this.mutate();
        mutator.accept(builder);
        return builder.build();
    }

    boolean hasConnectionTimeout() {
        return this.connectTimeout != null;
    }

    int getConnectTimeoutMs() {
        if (this.connectTimeout == null) {
            throw new IllegalStateException("No connect timeout configured");
        }
        return Math.toIntExact(this.connectTimeout.toMillis());
    }

    ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    boolean hasLoopResources() {
        return this.loopResources != null;
    }

    LoopResources getRequiredLoopResources() {
        if (!this.hasLoopResources()) {
            throw new IllegalStateException("No LoopResources configured");
        }
        return this.loopResources;
    }

    SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    LogLevel getErrorResponseLogLevel() {
        return this.errorResponseLogLevel;
    }

    LogLevel getNoticeLogLevel() {
        return this.noticeLogLevel;
    }

    public static final class Builder {
        private Duration connectTimeout;
        private ConnectionProvider connectionProvider = ConnectionProvider.newConnection();
        private LoopResources loopResources = null;
        private LogLevel errorResponseLogLevel = LogLevel.WARN;
        private LogLevel noticeLogLevel = LogLevel.DEBUG;
        private SSLConfig sslConfig = new SSLConfig(SSLMode.DISABLE, null, null);
        private boolean tcpKeepAlive;
        private boolean tcpNoDelay;

        private Builder() {
        }

        public ConnectionSettings build() {
            return new ConnectionSettings(this.connectTimeout, this.connectionProvider, this.loopResources, this.sslConfig, this.tcpKeepAlive, this.tcpNoDelay, this.errorResponseLogLevel, this.noticeLogLevel);
        }

        public Builder connectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder connectionProvider(ConnectionProvider connectionProvider) {
            this.connectionProvider = Assert.requireNonNull(connectionProvider, "connectionProvider must not be null");
            return this;
        }

        public Builder loopResources(@Nullable LoopResources loopResources) {
            this.loopResources = loopResources;
            return this;
        }

        public Builder errorResponseLogLevel(LogLevel errorResponseLogLevel) {
            this.errorResponseLogLevel = Assert.requireNonNull(errorResponseLogLevel, "errorResponseLogLevel must not be null");
            return this;
        }

        public Builder noticeLogLevel(LogLevel noticeLogLevel) {
            this.noticeLogLevel = Assert.requireNonNull(noticeLogLevel, "noticeLogLevel must not be null");
            return this;
        }

        public Builder sslConfig(SSLConfig sslConfig) {
            this.sslConfig = Assert.requireNonNull(sslConfig, "sslConfig must not be null");
            return this;
        }

        public Builder tcpKeepAlive(boolean enabled) {
            this.tcpKeepAlive = enabled;
            return this;
        }

        public Builder tcpNoDelay(boolean enabled) {
            this.tcpNoDelay = enabled;
            return this;
        }
    }
}

