/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.RequestContext;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.client.ClientSession;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.AbstractReferenceCounted;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.binding.TransactionContext;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import org.bson.assertions.Assertions;

public class ClientSessionBinding
extends AbstractReferenceCounted
implements ReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    public ClientSessionBinding(ClientSession session, boolean ownsSession, ClusterAwareReadWriteBinding wrapped) {
        this.wrapped = wrapped;
        wrapped.retain();
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.ownsSession = ownsSession;
        this.sessionContext = new SyncClientSessionContext(session);
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public ClientSessionBinding retain() {
        super.retain();
        return this;
    }

    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.release();
            if (this.ownsSession) {
                this.session.close();
            }
        }
        return count;
    }

    public ConnectionSource getReadConnectionSource() {
        if (this.isConnectionSourcePinningRequired()) {
            return new SessionBindingConnectionSource(this.getPinnedConnectionSource(true));
        }
        return new SessionBindingConnectionSource(this.wrapped.getReadConnectionSource());
    }

    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        if (this.isConnectionSourcePinningRequired()) {
            return new SessionBindingConnectionSource(this.getPinnedConnectionSource(true));
        }
        return new SessionBindingConnectionSource(this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference));
    }

    public ConnectionSource getWriteConnectionSource() {
        if (this.isConnectionSourcePinningRequired()) {
            return new SessionBindingConnectionSource(this.getPinnedConnectionSource(false));
        }
        return new SessionBindingConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    public RequestContext getRequestContext() {
        return this.wrapped.getRequestContext();
    }

    public OperationContext getOperationContext() {
        return this.wrapped.getOperationContext();
    }

    private boolean isConnectionSourcePinningRequired() {
        ClusterType clusterType = this.wrapped.getCluster().getDescription().getType();
        return this.session.hasActiveTransaction() && (clusterType == ClusterType.SHARDED || clusterType == ClusterType.LOAD_BALANCED);
    }

    private ConnectionSource getPinnedConnectionSource(boolean isRead) {
        ConnectionSource source;
        TransactionContext transactionContext = TransactionContext.get((com.mongodb.session.ClientSession)this.session);
        if (transactionContext == null) {
            source = isRead ? this.wrapped.getReadConnectionSource() : this.wrapped.getWriteConnectionSource();
            transactionContext = new TransactionContext(this.wrapped.getCluster().getDescription().getType());
            this.session.setTransactionContext(source.getServerDescription().getAddress(), transactionContext);
            transactionContext.release();
        } else {
            source = this.wrapped.getConnectionSource((ServerAddress)Assertions.assertNotNull((Object)this.session.getPinnedServerAddress()));
        }
        return source;
    }

    private final class SyncClientSessionContext
    extends ClientSessionContext {
        private final ClientSession clientSession;

        SyncClientSessionContext(ClientSession clientSession) {
            super((com.mongodb.session.ClientSession)clientSession);
            this.clientSession = clientSession;
        }

        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return (ReadConcern)Assertions.assertNotNull((Object)this.clientSession.getTransactionOptions().getReadConcern());
            }
            if (this.isSnapshot()) {
                return ReadConcern.SNAPSHOT;
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingConnectionSource
    implements ConnectionSource {
        private ConnectionSource wrapped;

        SessionBindingConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
            ClientSessionBinding.this.retain();
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        public OperationContext getOperationContext() {
            return this.wrapped.getOperationContext();
        }

        public ServerApi getServerApi() {
            return this.wrapped.getServerApi();
        }

        public RequestContext getRequestContext() {
            return this.wrapped.getRequestContext();
        }

        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        public Connection getConnection() {
            TransactionContext transactionContext = TransactionContext.get((com.mongodb.session.ClientSession)ClientSessionBinding.this.session);
            if (transactionContext != null && transactionContext.isConnectionPinningRequired()) {
                Connection pinnedConnection = (Connection)transactionContext.getPinnedConnection();
                if (pinnedConnection == null) {
                    Connection connection = this.wrapped.getConnection();
                    transactionContext.pinConnection((ReferenceCounted)connection, Connection::markAsPinned);
                    return connection;
                }
                return pinnedConnection.retain();
            }
            return this.wrapped.getConnection();
        }

        public ConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public int release() {
            int count = this.wrapped.release();
            if (count == 0) {
                ClientSessionBinding.this.release();
            }
            return count;
        }
    }
}

