/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.facebook;

import com.fasterxml.jackson.databind.JsonNode;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.social.facebook.FacebookIdentityProviderConfig;

public class FacebookIdentityProvider
extends AbstractOAuth2IdentityProvider<FacebookIdentityProviderConfig>
implements SocialIdentityProvider<FacebookIdentityProviderConfig> {
    public static final String AUTH_URL = "https://graph.facebook.com/oauth/authorize";
    public static final String TOKEN_URL = "https://graph.facebook.com/oauth/access_token";
    public static final String PROFILE_URL = "https://graph.facebook.com/me?fields=id,name,email,first_name,last_name";
    public static final String DEFAULT_SCOPE = "email";
    protected static final String PROFILE_URL_FIELDS_SEPARATOR = ",";

    public FacebookIdentityProvider(KeycloakSession session, FacebookIdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            String fetchedFields = ((FacebookIdentityProviderConfig)this.getConfig()).getFetchedFields();
            String url = StringUtil.isNotNull((String)fetchedFields) ? String.join((CharSequence)PROFILE_URL_FIELDS_SEPARATOR, PROFILE_URL, fetchedFields) : PROFILE_URL;
            JsonNode profile = SimpleHttp.doGet((String)url, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken).asJson();
            return this.extractIdentityFromProfile(null, profile);
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from facebook.", (Throwable)e);
        }
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    protected String getProfileEndpointForValidation(EventBuilder event) {
        return PROFILE_URL;
    }

    @Override
    protected BrokeredIdentityContext extractIdentityFromProfile(EventBuilder event, JsonNode profile) {
        String id = this.getJsonProperty(profile, "id");
        BrokeredIdentityContext user = new BrokeredIdentityContext(id);
        String email = this.getJsonProperty(profile, DEFAULT_SCOPE);
        user.setEmail(email);
        String username = this.getJsonProperty(profile, "username");
        if (username == null) {
            username = email != null ? email : id;
        }
        user.setUsername(username);
        String firstName = this.getJsonProperty(profile, "first_name");
        String lastName = this.getJsonProperty(profile, "last_name");
        lastName = lastName == null ? "" : " " + lastName;
        user.setName(firstName + lastName);
        user.setIdpConfig(this.getConfig());
        user.setIdp((IdentityProvider)this);
        AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, ((FacebookIdentityProviderConfig)this.getConfig()).getAlias());
        return user;
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

