/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.console;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.ConsoleDisplayMode;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class ConsoleUsernamePasswordAuthenticator
extends AbstractUsernameFormAuthenticator
implements Authenticator {
    public static final ConsoleUsernamePasswordAuthenticator SINGLETON = new ConsoleUsernamePasswordAuthenticator();

    public boolean requiresUser() {
        return false;
    }

    protected ConsoleDisplayMode challenge(AuthenticationFlowContext context) {
        return ConsoleDisplayMode.challenge((AuthenticationFlowContext)context).header().param("username").label("console-username").param("password").label("console-password").mask(true).challenge();
    }

    public void authenticate(AuthenticationFlowContext context) {
        Response response = this.challenge(context).form().createForm("cli_splash.ftl");
        context.challenge(response);
    }

    @Override
    protected Response challenge(AuthenticationFlowContext context, String error) {
        return this.challenge(context).message(error, new String[0]);
    }

    @Override
    protected Response setDuplicateUserChallenge(AuthenticationFlowContext context, String eventError, String loginFormError, AuthenticationFlowError authenticatorError) {
        context.getEvent().error(eventError);
        Response response = this.challenge(context).message(loginFormError, new String[0]);
        context.failureChallenge(authenticatorError, response);
        return response;
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (!this.validateUserAndPassword(context, (MultivaluedMap<String, String>)formData)) {
            return;
        }
        context.success();
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public void close() {
    }
}

