/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.scheduler;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetlinks.rule.engine.api.scheduler.ScheduleJob;
import org.jetlinks.rule.engine.api.scheduler.Scheduler;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.task.TaskSnapshot;
import org.jetlinks.rule.engine.api.worker.Worker;
import org.jetlinks.rule.engine.cluster.scheduler.SchedulerRpcService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SchedulerRpcServiceImpl
implements SchedulerRpcService {
    private final Scheduler localScheduler;
    private static final Map<SchedulerRpcService.TaskOperation, Function<Task, Mono<Void>>> operationMapping = new EnumMap<SchedulerRpcService.TaskOperation, Function<Task, Mono<Void>>>(SchedulerRpcService.TaskOperation.class);

    public SchedulerRpcServiceImpl(Scheduler localScheduler) {
        this.localScheduler = localScheduler;
    }

    public Scheduler getLocalScheduler() {
        return this.localScheduler;
    }

    @Override
    public Mono<String> getId() {
        return Mono.just((Object)this.localScheduler.getId());
    }

    @Override
    public Flux<SchedulerRpcService.WorkerInfo> getWorkers() {
        return this.localScheduler.getWorkers().map(worker -> new SchedulerRpcService.WorkerInfo(worker.getId(), worker.getName()));
    }

    @Override
    public Mono<SchedulerRpcService.WorkerInfo> getWorker(String id) {
        return this.localScheduler.getWorker(id).map(worker -> new SchedulerRpcService.WorkerInfo(worker.getId(), worker.getName()));
    }

    @Override
    public Flux<SchedulerRpcService.TaskInfo> schedule(ScheduleJob job) {
        return this.localScheduler.schedule(job).map(task -> new SchedulerRpcService.TaskInfo(task.getId(), task.getName(), task.getWorkerId(), task.getJob()));
    }

    @Override
    public Mono<Void> shutdown(String instanceId) {
        return this.localScheduler.shutdown(instanceId);
    }

    @Override
    public Flux<SchedulerRpcService.TaskInfo> getSchedulingTask(String instanceId) {
        return this.localScheduler.getSchedulingTask(instanceId).map(task -> new SchedulerRpcService.TaskInfo(task.getId(), task.getName(), task.getWorkerId(), task.getJob()));
    }

    @Override
    public Flux<SchedulerRpcService.TaskInfo> getSchedulingTasks() {
        return this.localScheduler.getSchedulingTasks().map(task -> new SchedulerRpcService.TaskInfo(task.getId(), task.getName(), task.getWorkerId(), task.getJob()));
    }

    @Override
    public Mono<Long> totalTask() {
        return this.localScheduler.totalTask();
    }

    @Override
    public Mono<Boolean> canSchedule(ScheduleJob job) {
        return this.localScheduler.canSchedule(job);
    }

    @Override
    public Mono<Void> executeTask(SchedulerRpcService.ExecuteTaskRequest request) {
        return this.getTask0(request.getTaskId()).flatMap(task -> task.execute(request.getData())).then();
    }

    @Override
    public Mono<SchedulerRpcService.TaskInfo> getTask(String taskId) {
        return this.getTask0(taskId).map(task -> new SchedulerRpcService.TaskInfo(task.getId(), task.getName(), task.getWorkerId(), task.getJob()));
    }

    private Mono<Task> getTask0(String taskId) {
        return this.localScheduler.getTask(taskId);
    }

    @Override
    public Mono<Task.State> getTaskState(String taskId) {
        return this.getTask0(taskId).flatMap(Task::getState);
    }

    @Override
    public Mono<Void> taskOperation(SchedulerRpcService.OperateTaskRequest request) {
        if (request.getOperation() == SchedulerRpcService.TaskOperation.SHUTDOWN) {
            return this.localScheduler.shutdownTask(request.getTaskId());
        }
        return this.getTask0(request.getTaskId()).flatMap(task -> operationMapping.get((Object)request.getOperation()).apply((Task)task));
    }

    @Override
    public Mono<Void> setTaskJob(SchedulerRpcService.TaskJobRequest request) {
        return this.getTask0(request.getTaskId()).flatMap(task -> task.setJob(request.getJob()));
    }

    @Override
    public Mono<Long> getLastStateTime(String taskId) {
        return this.getTask0(taskId).flatMap(Task::getLastStateTime);
    }

    @Override
    public Mono<Long> getStartTime(String taskId) {
        return this.getTask0(taskId).flatMap(Task::getStartTime);
    }

    @Override
    public Mono<SchedulerRpcService.TaskInfo> createTask(SchedulerRpcService.CreateTaskRequest request) {
        return this.localScheduler.getWorker(request.getWorkerId()).flatMap(worker -> worker.createTask(this.localScheduler.getId(), request.getJob())).map(task -> new SchedulerRpcService.TaskInfo(task.getId(), task.getName(), task.getWorkerId(), task.getJob()));
    }

    @Override
    public Mono<List<String>> getSupportExecutors(String workerId) {
        return this.localScheduler.getWorker(workerId).flatMap(Worker::getSupportExecutors);
    }

    @Override
    public Mono<Worker.State> getWorkerState(String workerId) {
        return this.localScheduler.getWorker(workerId).flatMap(Worker::getState);
    }

    @Override
    public Mono<Boolean> isAlive() {
        return Mono.just((Object)true);
    }

    @Override
    public Mono<TaskSnapshot> dumpTask(String taskId) {
        return this.getTask0(taskId).flatMap(Task::dump);
    }

    static {
        operationMapping.put(SchedulerRpcService.TaskOperation.PAUSE, Task::pause);
        operationMapping.put(SchedulerRpcService.TaskOperation.START, Task::start);
        operationMapping.put(SchedulerRpcService.TaskOperation.SHUTDOWN, Task::shutdown);
        operationMapping.put(SchedulerRpcService.TaskOperation.RELOAD, Task::reload);
        operationMapping.put(SchedulerRpcService.TaskOperation.ENABLE_DEBUG, task -> task.debug(true));
        operationMapping.put(SchedulerRpcService.TaskOperation.DISABLE_DEBUG, task -> task.debug(false));
    }
}

