/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.validator;

import org.hswebframework.web.exception.I18nSupportException;

public class MethodInvokeDeniedException
extends I18nSupportException {
    private final String className;
    private final String methodName;
    private final String calledClassName;
    private final String calledMethodName;
    private final int lineNumber;

    public MethodInvokeDeniedException(String className, String methodName, String calledClassName, String calledMethodName, int lineNumber) {
        super("error.method.call.denied", new Object[]{MethodInvokeDeniedException.parseClassSimpleName(calledClassName), calledMethodName, MethodInvokeDeniedException.parseClassSimpleName(className), lineNumber});
        this.className = className;
        this.methodName = methodName;
        this.calledClassName = calledClassName;
        this.calledMethodName = calledMethodName;
        this.lineNumber = lineNumber;
    }

    private static String parseClassSimpleName(String name) {
        if (name.contains(".")) {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }

    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getCalledClassName() {
        return this.calledClassName;
    }

    public String getCalledMethodName() {
        return this.calledMethodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

