/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetlinks.core.Value;
import org.jetlinks.core.defaults.Authenticator;
import org.jetlinks.core.device.AuthenticationRequest;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.MqttAuthenticationRequest;
import reactor.core.publisher.Mono;

@Deprecated
public class JetLinksAuthenticator
implements Authenticator {
    public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest request, @Nonnull DeviceRegistry registry) {
        MqttAuthenticationRequest mqtt = (MqttAuthenticationRequest)request;
        return registry.getDevice(mqtt.getClientId()).flatMap(device -> this.authenticate(request, (DeviceOperator)device));
    }

    public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest request, @Nonnull DeviceOperator deviceOperation) {
        if (request instanceof MqttAuthenticationRequest) {
            MqttAuthenticationRequest mqtt = (MqttAuthenticationRequest)request;
            String username = mqtt.getUsername();
            String password = mqtt.getPassword();
            try {
                String[] arr = username.split("[|]");
                if (arr.length <= 1) {
                    return Mono.just((Object)AuthenticationResponse.error((int)401, (String)"\u7528\u6237\u540d\u683c\u5f0f\u9519\u8bef"));
                }
                String requestSecureId = arr[0];
                long time = Long.parseLong(arr[1]);
                if (Math.abs(System.currentTimeMillis() - time) > TimeUnit.MINUTES.toMillis(5L)) {
                    return Mono.just((Object)AuthenticationResponse.error((int)401, (String)"\u8bbe\u5907\u65f6\u95f4\u4e0d\u540c\u6b65"));
                }
                return deviceOperation.getConfigs(new String[]{"secureId", "secureKey"}).map(conf -> {
                    String secureId = conf.getValue("secureId").map(Value::asString).orElse(null);
                    String secureKey = conf.getValue("secureKey").map(Value::asString).orElse(null);
                    String digest = DigestUtils.md5Hex((String)(username + "|" + secureKey));
                    if (requestSecureId.equals(secureId) && digest.equals(password)) {
                        return AuthenticationResponse.success((String)deviceOperation.getDeviceId());
                    }
                    return AuthenticationResponse.error((int)401, (String)"\u5bc6\u94a5\u9519\u8bef");
                });
            }
            catch (NumberFormatException e) {
                return Mono.just((Object)AuthenticationResponse.error((int)401, (String)"\u7528\u6237\u540d\u683c\u5f0f\u9519\u8bef"));
            }
        }
        return Mono.just((Object)AuthenticationResponse.error((int)400, (String)("\u4e0d\u652f\u6301\u7684\u6388\u6743\u7c7b\u578b:" + request)));
    }
}

