/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.config;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigStorage;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class InMemoryConfigStorage
implements ConfigStorage {
    private final ConcurrentMap<String, Object> storage = new ConcurrentHashMap<String, Object>();

    public Mono<Value> getConfig(String key) {
        return Mono.fromSupplier(() -> this.storage.get(key)).map(Value::simple);
    }

    public Mono<Values> getConfigs(Collection<String> key) {
        return Flux.fromIterable(key).filter(this.storage::containsKey).map(k -> Tuples.of((Object)k, this.storage.get(k))).collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2)).map(Values::of);
    }

    public Mono<Boolean> setConfigs(Map<String, Object> values) {
        values.forEach(this::doSetConfig);
        return Mono.just((Object)true);
    }

    public void doSetConfig(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        this.storage.put(key, value);
    }

    public Mono<Boolean> setConfig(String key, Object value) {
        this.doSetConfig(key, value);
        return Mono.just((Object)true);
    }

    public Mono<Boolean> remove(String key) {
        return Mono.justOrEmpty((Object)key).doOnNext(this.storage::remove).thenReturn((Object)true);
    }

    public Mono<Value> getAndRemove(String key) {
        return this.getConfig(key).flatMap(v -> this.remove(key).thenReturn(v));
    }

    public Mono<Boolean> remove(Collection<String> key) {
        return Flux.fromIterable(key).doOnNext(this.storage::remove).then().thenReturn((Object)true);
    }

    public Mono<Boolean> clear() {
        return Mono.fromRunnable(this.storage::clear);
    }
}

