/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.codec.defaults;

import io.netty.buffer.ByteBufUtil;
import org.jetlinks.supports.protocol.codec.BinaryCodec;

public class HexStringCodec
implements BinaryCodec<String> {
    private final int offset;
    private final int length;

    @Override
    public String decode(byte[] payload, int offset) {
        offset = this.offset + offset;
        int readableLength = payload.length - offset;
        if (this.length != -1) {
            readableLength = Math.min(this.length, readableLength);
        }
        return ByteBufUtil.hexDump((byte[])payload, (int)(this.offset + offset), (int)readableLength);
    }

    @Override
    public void encode(String part, byte[] payload, int offset) {
        byte[] data = ByteBufUtil.decodeHexDump((CharSequence)part);
        System.arraycopy(data, 0, payload, this.offset + offset, data.length);
    }

    private HexStringCodec(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public static HexStringCodec of(int offset, int length) {
        return new HexStringCodec(offset, length);
    }
}

