/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public class JetLinksEnumCodec
extends AbstractDataTypeCodec<EnumType> {
    public String getTypeId() {
        return "enum";
    }

    @Override
    public EnumType decode(EnumType type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        Optional.ofNullable(jsonObject.getJSONArray("elements")).map(list -> list.stream().map(JSONObject.class::cast).map(e -> EnumType.Element.of((String)e.getString("value"), (String)e.getString("text"), (String)e.getString("description"))).collect(Collectors.toList())).ifPresent(arg_0 -> ((EnumType)type).setElements(arg_0));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, EnumType type) {
        super.doEncode(encoded, type);
        if (type.getElements() == null) {
            return;
        }
        encoded.put("elements", type.getElements().stream().map(EnumType.Element::toMap).collect(Collectors.toList()));
    }
}

