/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.jetlinks.core.Value;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.CoapExchangeMessage;
import org.jetlinks.core.message.codec.CoapMessage;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.supports.official.JetlinksTopicMessageCodec;
import org.jetlinks.supports.official.cipher.Ciphers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Deprecated
public class JetLinksCoapDeviceMessageCodec
extends JetlinksTopicMessageCodec
implements DeviceMessageCodec {
    private static final Logger log = LoggerFactory.getLogger(JetLinksCoapDeviceMessageCodec.class);

    public Transport getSupportTransport() {
        return DefaultTransport.CoAP;
    }

    protected JSONObject decode(String text) {
        return JSON.parseObject((String)text);
    }

    protected Mono<? extends Message> decode(CoapMessage message, MessageDecodeContext context) {
        String path = message.getPath();
        return context.getDevice().getConfigs(new String[]{"encAlg", "secureKey"}).flatMap(configs -> {
            Ciphers ciphers = configs.getValue("encAlg").map(Value::asString).flatMap(Ciphers::of).orElse(Ciphers.AES);
            String secureKey = configs.getValue("secureKey").map(Value::asString).orElse(null);
            ByteBuf byteBuf = message.getPayload();
            byte[] req = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(req);
            byteBuf.resetReaderIndex();
            String payload = new String(ciphers.decrypt(req, secureKey));
            return Mono.just((Object)this.decode(path, this.decode(payload)).getMessage());
        });
    }

    protected Mono<? extends Message> decode(CoapExchangeMessage message, MessageDecodeContext context) {
        CoapExchange exchange = message.getExchange();
        return this.decode((CoapMessage)message, context).doOnSuccess(msg -> {
            exchange.respond(CoAP.ResponseCode.CREATED);
            exchange.accept();
        }).switchIfEmpty(Mono.fromRunnable(() -> exchange.respond(CoAP.ResponseCode.BAD_REQUEST))).doOnError(error -> {
            log.error("decode coap message error", error);
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST);
        });
    }

    @Nonnull
    public Mono<? extends Message> decode(@Nonnull MessageDecodeContext context) {
        return Mono.defer(() -> {
            log.debug("handle coap message:\n{}", (Object)context.getMessage());
            if (context.getMessage() instanceof CoapExchangeMessage) {
                return this.decode((CoapExchangeMessage)context.getMessage(), context);
            }
            if (context.getMessage() instanceof CoapMessage) {
                return this.decode((CoapMessage)context.getMessage(), context);
            }
            return Mono.empty();
        });
    }

    @Nonnull
    public Mono<? extends EncodedMessage> encode(@Nonnull MessageEncodeContext context) {
        return Mono.empty();
    }
}

