/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.config;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jctools.maps.NonBlockingHashMap;
import org.jetlinks.core.cluster.ClusterCache;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.supports.config.CacheNotify;
import org.jetlinks.supports.config.LocalCacheClusterConfigStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

public class EventBusStorageManager
implements ConfigStorageManager,
Disposable {
    private static final Logger log = LoggerFactory.getLogger(EventBusStorageManager.class);
    static final String NOTIFY_TOPIC = "/_sys/cluster_cache";
    private static final AtomicReferenceFieldUpdater<EventBusStorageManager, Disposable> CLUSTER_SUBSCRIBER = AtomicReferenceFieldUpdater.newUpdater(EventBusStorageManager.class, Disposable.class, "disposable");
    final ConcurrentMap<String, LocalCacheClusterConfigStorage> cache;
    private volatile Disposable disposable;
    private final EventBus eventBus;
    private final Function<String, LocalCacheClusterConfigStorage> storageBuilder;

    public EventBusStorageManager(ClusterManager clusterManager, EventBus eventBus) {
        this(clusterManager, eventBus, -1L);
    }

    public EventBusStorageManager(ClusterManager clusterManager, EventBus eventBus, long ttl) {
        this.cache = new NonBlockingHashMap();
        this.eventBus = eventBus;
        this.storageBuilder = id -> new LocalCacheClusterConfigStorage((String)id, eventBus, (ClusterCache<String, Object>)clusterManager.createCache(id), ttl, () -> this.cache.remove(id));
    }

    public EventBusStorageManager(ClusterManager clusterManager, EventBus eventBus, Supplier<ConcurrentMap<String, Object>> cacheSupplier) {
        this.eventBus = eventBus;
        this.cache = cacheSupplier.get();
        this.storageBuilder = id -> new LocalCacheClusterConfigStorage((String)id, eventBus, (ClusterCache<String, Object>)clusterManager.createCache(id), -1L, () -> this.cache.remove(id), (Map)cacheSupplier.get());
    }

    private Disposable subscribeCluster() {
        return this.eventBus.subscribe(Subscription.builder().subscriberId("event-bus-storage-listener").topics(new String[]{NOTIFY_TOPIC}).justBroker().build(), topicPayload -> {
            try {
                CacheNotify cacheNotify = (CacheNotify)topicPayload.decode();
                LocalCacheClusterConfigStorage storage = (LocalCacheClusterConfigStorage)this.cache.get(cacheNotify.getName());
                if (storage != null) {
                    log.trace("clear local cache :{}", (Object)cacheNotify);
                    storage.clearLocalCache(cacheNotify);
                } else {
                    log.trace("ignore clear local cache :{}", (Object)cacheNotify);
                }
            }
            catch (Throwable error) {
                log.warn("clear local cache error", error);
            }
            return Mono.empty();
        });
    }

    public void dispose() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<ConfigStorage> getStorage(String id) {
        if (this.disposable == null) {
            EventBusStorageManager eventBusStorageManager = this;
            synchronized (eventBusStorageManager) {
                Disposable disp = this.subscribeCluster();
                if (!CLUSTER_SUBSCRIBER.compareAndSet(this, null, disp)) {
                    disp.dispose();
                }
            }
        }
        return Mono.fromSupplier(() -> this.cache.computeIfAbsent(id, this.storageBuilder));
    }
}

