/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPatterns {
    private static final FalsePattern FALSE_PATTERN = new FalsePattern();

    @NotNull
    public static StringPattern string() {
        StringPattern stringPattern = StringPattern.STRING_PATTERN;
        if (stringPattern == null) {
            StandardPatterns.$$$reportNull$$$0(0);
        }
        return stringPattern;
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> instanceOf(Class<T> aClass2) {
        ObjectPattern.Capture<T> capture = new ObjectPattern.Capture<T>(aClass2);
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(2);
        }
        return capture;
    }

    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns2) {
        if (patterns2 == null) {
            StandardPatterns.$$$reportNull$$$0(13);
        }
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                for (ElementPattern pattern : patterns2) {
                    if (!pattern.accepts(o, context2)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean first2 = true;
                for (ElementPattern pattern : patterns2) {
                    if (!first2) {
                        builder.append("\n").append(indent);
                    }
                    first2 = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$3", "append"));
            }
        });
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(14);
        }
        return capture;
    }

    @NotNull
    public static <E> ObjectPattern.Capture<E> not(final ElementPattern<E> pattern) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                return !pattern.accepts(o, context2);
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    5.$$$reportNull$$$0(0);
                }
                pattern.getCondition().append(builder.append("not("), indent + "  ");
                builder.append(")");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$5", "append"));
            }
        });
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(17);
        }
        return capture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/StandardPatterns";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "string";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "character";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "instanceOf";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/StandardPatterns";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "save";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "object";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "composeInitialConditions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "optional";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysFalse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "object";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FalsePattern
    implements ElementPattern {
        private FalsePattern() {
        }

        @Override
        public boolean accepts(@Nullable Object o) {
            return false;
        }

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context2) {
            return false;
        }

        public ElementPatternCondition getCondition() {
            return new ElementPatternCondition(new InitialPatternCondition(Object.class){

                @Override
                public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                    return false;
                }
            });
        }
    }
}

