/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.extractors;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ClientContext;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractor;
import org.jboss.resteasy.plugins.providers.sse.EventInput;
import org.jboss.resteasy.util.Types;
import org.reactivestreams.Publisher;

public class BodyEntityExtractor
implements EntityExtractor {
    private final Method method;

    public BodyEntityExtractor(Method method) {
        this.method = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractEntity(ClientContext context, Object ... args) {
        ClientResponse response = context.getClientResponse();
        boolean releaseConnectionAfter = response.getStatus() >= 200 && response.getStatus() < 300;
        try {
            if (this.method.getReturnType() == null) {
                throw new RuntimeException(Messages.MESSAGES.noTypeInformation());
            }
            Type type = Types.resolveTypeVariables(context.getInvocation().getClientInvoker().getDeclaring(), (Type)this.method.getGenericReturnType());
            GenericType gt = null;
            gt = !(type instanceof TypeVariable) ? new GenericType(type) : new GenericType(this.method.getReturnType());
            Object obj = ClientInvocation.extractResult(gt, (Response)response, this.method.getAnnotations());
            if (obj instanceof InputStream || obj instanceof Reader || obj instanceof Publisher || obj instanceof EventInput) {
                releaseConnectionAfter = false;
            }
            Object t = obj;
            return t;
        }
        finally {
            if (releaseConnectionAfter) {
                response.close();
            }
        }
    }
}

