/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mysql;

import java.sql.Date;
import java.sql.JDBCType;
import org.hswebframework.ezorm.core.utils.StringUtils;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.JdbcDataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.DefaultDialect;

public class MysqlDialect
extends DefaultDialect {
    public MysqlDialect() {
        this.addDataTypeBuilder(JDBCType.CHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"char(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.VARCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"varchar(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.NVARCHAR, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"nvarchar(", meta.getLength(), ")"}));
        this.addDataTypeBuilder(JDBCType.TIMESTAMP, (RDBColumnMetadata meta) -> "datetime(" + Math.min(6, meta.getLength()) + ")");
        this.addDataTypeBuilder(JDBCType.TIME, (RDBColumnMetadata meta) -> "time");
        this.addDataTypeBuilder(JDBCType.DATE, (RDBColumnMetadata meta) -> "date");
        this.addDataTypeBuilder(JDBCType.CLOB, (RDBColumnMetadata meta) -> "text");
        this.addDataTypeBuilder(JDBCType.LONGVARBINARY, (RDBColumnMetadata meta) -> "blob");
        this.addDataTypeBuilder(JDBCType.LONGVARCHAR, (RDBColumnMetadata meta) -> "longtext");
        this.addDataTypeBuilder(JDBCType.BLOB, (RDBColumnMetadata meta) -> "blob");
        this.addDataTypeBuilder(JDBCType.BIGINT, (RDBColumnMetadata meta) -> "bigint");
        this.addDataTypeBuilder(JDBCType.DOUBLE, (RDBColumnMetadata meta) -> "double");
        this.addDataTypeBuilder(JDBCType.INTEGER, (RDBColumnMetadata meta) -> "int");
        this.addDataTypeBuilder(JDBCType.NUMERIC, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"decimal(", meta.getPrecision(32), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.DECIMAL, (RDBColumnMetadata meta) -> StringUtils.concat((Object[])new Object[]{"decimal(", meta.getPrecision(32), ",", meta.getScale(), ")"}));
        this.addDataTypeBuilder(JDBCType.TINYINT, (RDBColumnMetadata meta) -> "tinyint");
        this.addDataTypeBuilder(JDBCType.BOOLEAN, (RDBColumnMetadata meta) -> "tinyint");
        this.addDataTypeBuilder(JDBCType.BIGINT, (RDBColumnMetadata meta) -> "bigint");
        this.addDataTypeBuilder(JDBCType.OTHER, (RDBColumnMetadata meta) -> "other");
        this.addDataTypeBuilder(JDBCType.LONGNVARCHAR, (RDBColumnMetadata meta) -> "text");
        this.addDataTypeBuilder("int", (RDBColumnMetadata meta) -> "int");
        this.addDataTypeBuilder("json", (RDBColumnMetadata meta) -> "json");
        this.registerDataType("clob", DataType.builder(JdbcDataType.of(JDBCType.CLOB, String.class), c -> "text"));
        this.registerDataType("longnvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGNVARCHAR, String.class), c -> "longtext"));
        this.registerDataType("longvarchar", DataType.builder(JdbcDataType.of(JDBCType.LONGVARCHAR, String.class), c -> "longtext"));
        this.registerDataType("int", JdbcDataType.of(JDBCType.INTEGER, Integer.class));
        this.registerDataType("text", JdbcDataType.of(JDBCType.CLOB, String.class));
        this.registerDataType("longtext", JdbcDataType.of(JDBCType.LONGVARCHAR, String.class));
        this.registerDataType("year", JdbcDataType.of(JDBCType.DATE, Date.class));
        this.registerDataType("text", JdbcDataType.of(JDBCType.CLOB, Date.class));
        this.registerDataType("datetime", JdbcDataType.of(JDBCType.TIMESTAMP, Date.class));
    }

    @Override
    public String getQuoteStart() {
        return "`";
    }

    @Override
    public String getQuoteEnd() {
        return "`";
    }

    @Override
    public boolean isColumnToUpperCase() {
        return false;
    }

    public String getId() {
        return "mysql";
    }

    public String getName() {
        return "Mysql";
    }
}

