/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.term;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.TermFragmentBuilder;

public abstract class AbstractTermFragmentBuilder
implements TermFragmentBuilder {
    private final String termType;
    private final String name;

    protected List<Object> convertList(RDBColumnMetadata column, Term term) {
        Object value = term.getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            value = ((String)value).split(",");
        }
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        }
        if (value instanceof Collection) {
            Collection listValue = (Collection)value;
            ArrayList<Object> list = new ArrayList<Object>(listValue.size());
            for (Object val : listValue) {
                list.add(this.convertValue(column, val));
            }
            return list;
        }
        return Arrays.asList(this.convertValue(column, value));
    }

    protected TableOrViewMetadata getTable(String tableName, RDBColumnMetadata baseOn) {
        return baseOn.getOwner().getSchema().getTableOrView(tableName).orElseThrow(() -> new UnsupportedOperationException("table " + tableName + " does not exist"));
    }

    protected String getTableName(String tableName, RDBColumnMetadata baseOn) {
        return this.getTable(tableName, baseOn).getFullName();
    }

    private Object convertValue(RDBColumnMetadata column, Object val) {
        if (column == null) {
            return val;
        }
        return column.encode(val);
    }

    protected Object convertValue(RDBColumnMetadata column, Term term) {
        if (term.getValue() instanceof NativeSql) {
            return term.getValue();
        }
        return this.convertValue(column, term.getValue());
    }

    protected PrepareSqlFragments appendPrepareOrNative(PrepareSqlFragments sql, Object value) {
        if (value instanceof NativeSql) {
            NativeSql nativeSql = (NativeSql)value;
            sql.addSql(nativeSql.getSql()).addParameter(nativeSql.getParameters());
        } else {
            sql.addSql("?").addParameter(value);
        }
        return sql;
    }

    public AbstractTermFragmentBuilder(String termType, String name) {
        this.termType = termType;
        this.name = name;
    }

    @Override
    public String getTermType() {
        return this.termType;
    }

    public String getName() {
        return this.name;
    }
}

