/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hswebframework.ezorm.rdb.operator.builder.FragmentBlock;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;

public class BlockSqlFragments
implements SqlFragments {
    private final Map<FragmentBlock, LinkedList<SqlFragments>> blocks = new TreeMap<FragmentBlock, LinkedList<SqlFragments>>(Enum::compareTo);

    @Override
    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    @Override
    public List<String> getSql() {
        ArrayList<String> sql = new ArrayList<String>(this.blocks.size() * 5);
        for (LinkedList<SqlFragments> value : this.blocks.values()) {
            for (SqlFragments fragments : value) {
                sql.addAll(fragments.getSql());
            }
        }
        return sql;
    }

    @Override
    public List<Object> getParameters() {
        ArrayList<Object> sql = new ArrayList<Object>(this.blocks.size() * 5);
        for (LinkedList<SqlFragments> value : this.blocks.values()) {
            for (SqlFragments fragments : value) {
                sql.addAll(fragments.getParameters());
            }
        }
        return sql;
    }

    public BlockSqlFragments addBlock(FragmentBlock block, String sql) {
        this.getBlock(block).add(SqlFragments.single(sql));
        return this;
    }

    public BlockSqlFragments addBlockFirst(FragmentBlock block, String sql) {
        this.getBlock(block).addFirst(SqlFragments.single(sql));
        return this;
    }

    public BlockSqlFragments addBlock(FragmentBlock block, SqlFragments fragments) {
        this.getBlock(block).add(fragments);
        return this;
    }

    public BlockSqlFragments addBlockFirst(FragmentBlock block, SqlFragments fragments) {
        this.getBlock(block).addFirst(fragments);
        return this;
    }

    public LinkedList<SqlFragments> getBlock(FragmentBlock block) {
        return this.blocks.computeIfAbsent(block, __ -> new LinkedList());
    }

    public String toString() {
        return this.toRequest().toString();
    }

    private BlockSqlFragments() {
    }

    public static BlockSqlFragments of() {
        return new BlockSqlFragments();
    }
}

