/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.executor;

import java.util.ArrayList;
import java.util.function.Function;
import org.hswebframework.ezorm.core.GlobalConfig;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;

public class SqlTemplateParser {
    private static final char[] DEFAULT_PREPARE_START_SYMBOL = "#{".toCharArray();
    private static final char[] DEFAULT_PREPARE_END_SYMBOL = "}".toCharArray();
    private char[] prepareStartSymbol = DEFAULT_PREPARE_START_SYMBOL;
    private char[] prepareEndSymbol = DEFAULT_PREPARE_END_SYMBOL;
    private String template;
    private Object parameter;
    private char[] templateArray;
    private int pos;
    private char symbol;

    private void init() {
        this.templateArray = this.template.toCharArray();
        this.pos = 0;
    }

    private boolean isPrepare() {
        for (char c : this.prepareStartSymbol) {
            if (c != this.symbol) continue;
            return true;
        }
        return false;
    }

    private boolean isPrepareEnd() {
        for (char c : this.prepareEndSymbol) {
            if (c != this.symbol) continue;
            return true;
        }
        return false;
    }

    private boolean next() {
        this.symbol = this.templateArray[this.pos++];
        return this.pos < this.templateArray.length;
    }

    protected Object getProperty(String name) {
        return GlobalConfig.getPropertyOperator().getProperty(this.parameter, name).orElse(null);
    }

    public SqlRequest parse(Function<String, Object> propertyMapping) {
        this.init();
        boolean inPrepare = false;
        int len = 0;
        char[] newArr = new char[this.templateArray.length];
        char[] expression = new char[128];
        int expressionPos = 0;
        ArrayList<Object> parameters = new ArrayList<Object>(64);
        while (this.next()) {
            if (this.isPrepare()) {
                inPrepare = true;
                continue;
            }
            if (this.isPrepareEnd()) {
                inPrepare = false;
                parameters.add(propertyMapping.apply(new String(expression, 0, expressionPos)));
                expressionPos = 0;
                newArr[len++] = 63;
                continue;
            }
            if (inPrepare) {
                expression[expressionPos++] = this.symbol;
                continue;
            }
            newArr[len++] = this.symbol;
        }
        if (this.isPrepareEnd()) {
            newArr[len++] = 63;
            parameters.add(propertyMapping.apply(new String(expression, 0, expressionPos)));
        } else {
            newArr[len++] = this.symbol;
        }
        return SqlRequests.prepare(new String(newArr, 0, len), parameters.toArray());
    }

    public SqlRequest parse() {
        return this.parse(this::getProperty);
    }

    public static SqlRequest parse(String template, Object parameter) {
        SqlTemplateParser parser = new SqlTemplateParser();
        parser.parameter = parameter;
        parser.template = template;
        return parser.parse();
    }

    public static SqlRequest parse(String template, Function<String, Object> parameterGetter) {
        SqlTemplateParser parser = new SqlTemplateParser();
        parser.template = template;
        return parser.parse(parameterGetter);
    }

    public char[] getPrepareStartSymbol() {
        return this.prepareStartSymbol;
    }

    public void setPrepareStartSymbol(char[] prepareStartSymbol) {
        this.prepareStartSymbol = prepareStartSymbol;
    }

    public char[] getPrepareEndSymbol() {
        return this.prepareEndSymbol;
    }

    public void setPrepareEndSymbol(char[] prepareEndSymbol) {
        this.prepareEndSymbol = prepareEndSymbol;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public void setParameter(Object parameter) {
        this.parameter = parameter;
    }
}

