/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.mysql;

import org.hswebframework.ezorm.core.meta.Feature;
import org.hswebframework.ezorm.rdb.codec.EnumValueCodec;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.dialect.Dialect;
import org.hswebframework.ezorm.rdb.operator.CompositeExceptionTranslation;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlAlterTableSqlBuilder;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlBatchUpsertOperator;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlCreateTableSqlBuilder;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlEnumInFragmentBuilder;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlIndexMetadataParser;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlJDBCExceptionTranslation;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlPaginator;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlR2DBCExceptionTranslation;
import org.hswebframework.ezorm.rdb.supports.mysql.MysqlTableMetadataParser;
import org.hswebframework.ezorm.rdb.utils.FeatureUtils;

public class MysqlSchemaMetadata
extends RDBSchemaMetadata {
    public MysqlSchemaMetadata(String name) {
        super(name);
        this.addFeature(new MysqlCreateTableSqlBuilder());
        this.addFeature(new MysqlAlterTableSqlBuilder());
        this.addFeature(new MysqlPaginator());
        this.addFeature((Feature)new MysqlIndexMetadataParser(this));
        this.addFeature((Feature)new MysqlTableMetadataParser(this));
        this.addFeature(Dialect.MYSQL);
        this.addFeature(new CompositeExceptionTranslation().add(FeatureUtils.r2dbcIsAlive(), () -> MysqlR2DBCExceptionTranslation.of(this)).add(MysqlJDBCExceptionTranslation.of(this)));
    }

    @Override
    public RDBTableMetadata newTable(String name) {
        RDBTableMetadata metadata = super.newTable(name);
        metadata.addFeature(new MysqlBatchUpsertOperator(metadata));
        metadata.setOnColumnAdded(column -> {
            if (column.getValueCodec() instanceof EnumValueCodec && ((EnumValueCodec)column.getValueCodec()).isToMask()) {
                column.addFeature(MysqlEnumInFragmentBuilder.in);
                column.addFeature(MysqlEnumInFragmentBuilder.notIn);
            }
        });
        return metadata;
    }

    @Override
    public void addTable(RDBTableMetadata metadata) {
        metadata.addFeature(new MysqlBatchUpsertOperator(metadata));
        super.addTable(metadata);
    }
}

