/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.supports.h2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.metadata.RDBIndexMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.parser.IndexMetadataParser;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class H2IndexMetadataParser
implements IndexMetadataParser {
    private static final Logger log = LoggerFactory.getLogger(H2IndexMetadataParser.class);
    private RDBSchemaMetadata schema;
    private static final String sql = "select index_name,table_name,column_name,ordering_specification,ordinal_position,is_unique from information_schema.index_columns where table_name=? and table_schema=?";
    private static final String byName = "select index_name,table_name,column_name,ordering_specification,ordinal_position,is_unique from information_schema.index_columns where index_name=? and table_schema=?";
    private static final String all = "select index_name,table_name,column_name,ordering_specification,ordinal_position,is_unique from information_schema.index_columns where table_schema=?";

    @Override
    public List<RDBIndexMetadata> parseTableIndex(String tableName) {
        return this.doSelect(SqlRequests.of(sql, tableName.toUpperCase(), this.schema.getName().toUpperCase()));
    }

    public Optional<RDBIndexMetadata> parseByName(String name) {
        return this.doSelect(SqlRequests.of(byName, name.toUpperCase(), this.schema.getName().toUpperCase())).stream().findFirst();
    }

    @Override
    public List<RDBIndexMetadata> parseAll() {
        return this.doSelect(SqlRequests.of(all, this.schema.getName().toUpperCase()));
    }

    @Override
    public Flux<RDBIndexMetadata> parseAllReactive() {
        return this.doSelectReactive(SqlRequests.of(all, this.schema.getName().toUpperCase()));
    }

    public Mono<RDBIndexMetadata> parseByNameReactive(String name) {
        return this.doSelectReactive(SqlRequests.of(byName, name.toUpperCase(), this.schema.getName().toUpperCase())).singleOrEmpty();
    }

    @Override
    public Flux<RDBIndexMetadata> parseTableIndexReactive(String tableName) {
        return this.doSelectReactive(SqlRequests.of(sql, tableName.toUpperCase(), this.schema.getName().toUpperCase()));
    }

    protected Flux<RDBIndexMetadata> doSelectReactive(SqlRequest sqlRequest) {
        H2IndexMetadataWrapper wrapper = new H2IndexMetadataWrapper();
        return ((ReactiveSqlExecutor)this.schema.findFeatureNow(ReactiveSqlExecutor.ID)).select(sqlRequest, ResultWrappers.lowerCase(ResultWrappers.map())).doOnNext(wrapper::completedWrapRow).thenMany((Publisher)Flux.defer(() -> Flux.fromIterable((Iterable)wrapper.getResult())));
    }

    protected List<RDBIndexMetadata> doSelect(SqlRequest sqlRequest) {
        return ((SyncSqlExecutor)this.schema.findFeatureNow(SyncSqlExecutor.ID)).select(sqlRequest, new H2IndexMetadataWrapper());
    }

    public H2IndexMetadataParser(RDBSchemaMetadata schema) {
        this.schema = schema;
    }

    class H2IndexMetadataWrapper
    implements ResultWrapper<Map<String, Object>, List<RDBIndexMetadata>> {
        Map<String, RDBIndexMetadata> group = new LinkedHashMap<String, RDBIndexMetadata>();

        H2IndexMetadataWrapper() {
        }

        @Override
        public Map<String, Object> newRowInstance() {
            return new HashMap<String, Object>();
        }

        @Override
        public void wrapColumn(ColumnWrapperContext<Map<String, Object>> context) {
            context.getRowInstance().put(context.getColumnLabel().toLowerCase(), context.getResult());
        }

        @Override
        public boolean completedWrapRow(Map<String, Object> result) {
            String name = (String)result.get("index_name");
            RDBIndexMetadata index = this.group.computeIfAbsent(name, __ -> new RDBIndexMetadata());
            index.setName(name.toLowerCase());
            index.setTableName(((String)result.get("table_name")).toLowerCase());
            index.setPrimaryKey(name.startsWith("PRIMARY_KEY"));
            index.setUnique(Boolean.TRUE.equals(result.get("is_unique")));
            RDBIndexMetadata.IndexColumn indexColumn = new RDBIndexMetadata.IndexColumn();
            indexColumn.setColumn(((String)result.get("column_name")).toLowerCase());
            indexColumn.setSort("ASC".equals(result.get("ordering_specification")) ? RDBIndexMetadata.IndexSort.asc : RDBIndexMetadata.IndexSort.desc);
            indexColumn.setSortIndex(((Number)result.get("ordinal_position")).intValue());
            index.getColumns().add(indexColumn);
            return true;
        }

        @Override
        public List<RDBIndexMetadata> getResult() {
            return new ArrayList<RDBIndexMetadata>(this.group.values());
        }
    }
}

