/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata.key;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.metadata.key.AssociationType;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyBuilder;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyColumn;
import org.hswebframework.ezorm.rdb.metadata.key.ForeignKeyMetadata;
import org.hswebframework.ezorm.rdb.operator.dml.JoinType;

public class LazyForeignKeyMetadata
implements ForeignKeyMetadata {
    private ForeignKeyBuilder builder;
    private TableOrViewMetadata mainTable;
    private List<ForeignKeyMetadata> preKey;
    private List<ForeignKeyColumn> columns;

    @Override
    public AssociationType getType() {
        return Optional.ofNullable(this.builder).map(ForeignKeyBuilder::getAssociationType).orElse(AssociationType.oneToOne);
    }

    public static LazyForeignKeyMetadata of(ForeignKeyBuilder builder, TableOrViewMetadata mainTable) {
        LazyForeignKeyMetadata metadata = new LazyForeignKeyMetadata();
        metadata.builder = builder;
        metadata.mainTable = mainTable;
        return metadata;
    }

    @Override
    public boolean isLogical() {
        return true;
    }

    @Override
    public boolean isToMany() {
        return this.getType().isToMany();
    }

    @Override
    public TableOrViewMetadata getSource() {
        return this.mainTable;
    }

    @Override
    public TableOrViewMetadata getTarget() {
        return this.mainTable.getSchema().getTableOrView(this.builder.getTarget()).orElseThrow(() -> new IllegalArgumentException("target [" + this.builder.getTarget() + "] doesn't exist"));
    }

    @Override
    public List<ForeignKeyColumn> getColumns() {
        if (this.columns == null) {
            this.columns = this.builder.getColumns().stream().map(columnBuilder -> new ForeignKeyColumn((ForeignKeyBuilder.ForeignKeyColumnBuilder)columnBuilder){
                private RDBColumnMetadata targetCache;
                private RDBColumnMetadata sourceCache;
                final /* synthetic */ ForeignKeyBuilder.ForeignKeyColumnBuilder val$columnBuilder;
                {
                    this.val$columnBuilder = foreignKeyColumnBuilder;
                }

                @Override
                public RDBColumnMetadata getTargetColumn() {
                    if (this.targetCache != null) {
                        return this.targetCache;
                    }
                    if (this.val$columnBuilder.getTargetColumn() == null || this.val$columnBuilder.getTargetColumn().isEmpty()) {
                        this.targetCache = LazyForeignKeyMetadata.this.getTarget().getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElseThrow(() -> new IllegalArgumentException("primary key column doesn't exist "));
                        return this.targetCache;
                    }
                    this.targetCache = LazyForeignKeyMetadata.this.getTarget().findColumn(this.val$columnBuilder.getTargetColumn()).orElseThrow(() -> new IllegalArgumentException("column [" + this.val$columnBuilder.getTargetColumn() + "] doesn't exist"));
                    return this.targetCache;
                }

                @Override
                public RDBColumnMetadata getSourceColumn() {
                    if (this.sourceCache != null) {
                        return this.sourceCache;
                    }
                    if (this.val$columnBuilder.getSourceColumn() == null || this.val$columnBuilder.getSourceColumn().isEmpty()) {
                        this.sourceCache = LazyForeignKeyMetadata.this.mainTable.getColumns().stream().filter(RDBColumnMetadata::isPrimaryKey).findFirst().orElseThrow(() -> new IllegalArgumentException("primary key column doesn't exist "));
                        return this.sourceCache;
                    }
                    this.sourceCache = LazyForeignKeyMetadata.this.mainTable.findColumn(this.val$columnBuilder.getSourceColumn()).orElseThrow(() -> new IllegalArgumentException("column [" + this.val$columnBuilder.getSourceColumn() + "] doesn't exist"));
                    return this.sourceCache;
                }
            }).collect(Collectors.toList());
        }
        return this.columns;
    }

    @Override
    public boolean isAutoJoin() {
        return this.builder.isAutoJoin();
    }

    @Override
    public JoinType getJoinType() {
        return this.builder.getJoinType();
    }

    @Override
    public List<Term> getTerms() {
        return this.builder.getTerms();
    }

    @Override
    public Optional<ForeignKeyMetadata> getMiddleForeignKey(String name) {
        return this.getMiddleForeignKeys().stream().filter(key -> key.equalsNameOrAlias(name) || key.getSource().equalsNameOrAlias(name)).findFirst();
    }

    @Override
    public List<ForeignKeyMetadata> getMiddleForeignKeys() {
        if (this.builder.getMiddleForeignKey() == null) {
            return Collections.emptyList();
        }
        if (this.preKey == null) {
            this.preKey = this.builder.getMiddleForeignKey().stream().map(builder -> LazyForeignKeyMetadata.of(builder, this.mainTable.getSchema().getTableOrView(builder.getSource()).orElseThrow(() -> new IllegalArgumentException("table or view [" + builder.getSource() + "] doesn't exist")))).collect(Collectors.toList());
        }
        return this.preKey;
    }

    public String getName() {
        return this.builder.getName();
    }

    public String getAlias() {
        return this.builder.getAlias();
    }

    public LazyForeignKeyMetadata clone() {
        return (LazyForeignKeyMetadata)super.clone();
    }
}

