/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hswebframework.ezorm.core.DefaultValue;
import org.hswebframework.ezorm.core.meta.FeatureSupportedMetadata;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.ezorm.rdb.executor.SyncSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.metadata.DataType;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.ValueCodecFactory;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.AlterRequest;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.AlterTableSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.ddl.CreateTableSqlBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.ColumnBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.ForeignKeyDSLBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.IndexBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.TableBuilder;
import org.hswebframework.ezorm.rdb.operator.ddl.TableDDLResultOperator;
import org.hswebframework.ezorm.rdb.utils.ExceptionUtils;
import reactor.core.publisher.Mono;

public class LazyTableBuilder
implements TableBuilder {
    private final String tableName;
    private final RDBSchemaMetadata schema;
    private final Set<String> removed = new HashSet<String>();
    private boolean dropColumn = false;
    private boolean allowAlter = true;
    private boolean autoLoad = true;
    private boolean merge = true;
    private final List<Consumer<RDBTableMetadata>> consumers = new ArrayList<Consumer<RDBTableMetadata>>();

    public LazyTableBuilder(RDBSchemaMetadata schema, String tableName) {
        this.tableName = tableName;
        this.schema = schema;
    }

    @Override
    public TableBuilder addColumn(RDBColumnMetadata column) {
        this.consumers.add(table -> table.addColumn(column));
        return this;
    }

    @Override
    public TableBuilder custom(Consumer<RDBTableMetadata> consumer) {
        this.consumers.add(consumer);
        return this;
    }

    @Override
    public ColumnBuilder addColumn() {
        return new LazyColumnBuilder();
    }

    @Override
    public ColumnBuilder addColumn(String name) {
        return new LazyColumnBuilder().name(name);
    }

    @Override
    public TableBuilder removeColumn(String name) {
        this.removed.add(name);
        return this;
    }

    @Override
    public TableBuilder dropColumn(String name) {
        this.removed.add(name);
        this.dropColumn = true;
        return this;
    }

    @Override
    public TableBuilder comment(String comment) {
        return this.custom(table -> table.setComment(comment));
    }

    @Override
    public TableBuilder alias(String name) {
        return this.custom(table -> table.setAlias(name));
    }

    @Override
    public TableBuilder allowAlter(boolean allow) {
        this.allowAlter = allow;
        return this;
    }

    @Override
    public TableBuilder autoLoad(boolean autoLoad) {
        this.autoLoad = autoLoad;
        return this;
    }

    @Override
    public TableBuilder merge(boolean merge) {
        this.merge = merge;
        return this;
    }

    @Override
    public IndexBuilder index() {
        return new LazyIndexBuilder();
    }

    @Override
    public ForeignKeyDSLBuilder foreignKey() {
        return new LazyForeignKeyDSLBuilder();
    }

    private SqlRequest buildAlterSql(RDBTableMetadata table, RDBTableMetadata oldTable) {
        return ((AlterTableSqlBuilder)this.schema.findFeatureNow(AlterTableSqlBuilder.ID)).build(AlterRequest.builder().allowDrop(this.dropColumn).newTable(table).allowAlter(this.allowAlter).oldTable(oldTable).build());
    }

    private void accept(RDBTableMetadata table) {
        for (Consumer<RDBTableMetadata> consumer : this.consumers) {
            consumer.accept(table);
        }
    }

    @Override
    public TableDDLResultOperator commit() {
        return new TableDDLResultOperator(){

            @Override
            public Boolean sync() {
                Runnable whenComplete;
                SqlRequest sqlRequest;
                RDBTableMetadata oldTable = LazyTableBuilder.this.schema.getTable(LazyTableBuilder.this.tableName, LazyTableBuilder.this.autoLoad).orElse(null);
                RDBTableMetadata newTable = oldTable != null ? oldTable.clone() : LazyTableBuilder.this.schema.newTable(LazyTableBuilder.this.tableName);
                for (Consumer consumer : LazyTableBuilder.this.consumers) {
                    consumer.accept(newTable);
                }
                if (oldTable != null) {
                    sqlRequest = LazyTableBuilder.this.buildAlterSql(newTable, oldTable);
                    whenComplete = LazyTableBuilder.this.merge ? () -> {
                        oldTable.merge(newTable);
                        LazyTableBuilder.this.removed.forEach(oldTable::removeColumn);
                    } : () -> oldTable.replace(newTable);
                } else {
                    sqlRequest = ((CreateTableSqlBuilder)LazyTableBuilder.this.schema.findFeatureNow(CreateTableSqlBuilder.ID)).build(newTable);
                    whenComplete = () -> LazyTableBuilder.this.schema.addTable(newTable);
                }
                if (sqlRequest.isEmpty()) {
                    whenComplete.run();
                    return true;
                }
                ExceptionUtils.translation(() -> {
                    ((SyncSqlExecutor)LazyTableBuilder.this.schema.findFeatureNow(SyncSqlExecutor.ID)).execute(sqlRequest);
                    return true;
                }, (FeatureSupportedMetadata)LazyTableBuilder.this.schema);
                whenComplete.run();
                return true;
            }

            @Override
            public Mono<Boolean> reactive() {
                ReactiveSqlExecutor sqlExecutor = (ReactiveSqlExecutor)LazyTableBuilder.this.schema.findFeatureNow(ReactiveSqlExecutor.ID);
                return LazyTableBuilder.this.schema.getTableReactive(LazyTableBuilder.this.tableName, LazyTableBuilder.this.autoLoad).map(oldTable -> {
                    RDBTableMetadata newTable = oldTable.clone();
                    LazyTableBuilder.this.accept(newTable);
                    SqlRequest request = LazyTableBuilder.this.buildAlterSql(newTable, oldTable);
                    if (request.isEmpty()) {
                        if (LazyTableBuilder.this.merge) {
                            oldTable.merge(newTable);
                            LazyTableBuilder.this.removed.forEach(oldTable::removeColumn);
                        } else {
                            oldTable.replace(newTable);
                        }
                        return Mono.just((Object)true);
                    }
                    return sqlExecutor.execute(request).doOnSuccess(ignore -> {
                        oldTable.merge(newTable);
                        LazyTableBuilder.this.removed.forEach(oldTable::removeColumn);
                    }).thenReturn((Object)true);
                }).switchIfEmpty(Mono.fromSupplier(() -> {
                    RDBTableMetadata newTable = LazyTableBuilder.this.schema.newTable(LazyTableBuilder.this.tableName);
                    LazyTableBuilder.this.accept(newTable);
                    SqlRequest request = ((CreateTableSqlBuilder)LazyTableBuilder.this.schema.findFeatureNow(CreateTableSqlBuilder.ID)).build(newTable);
                    if (request.isEmpty()) {
                        return Mono.just((Object)true);
                    }
                    return sqlExecutor.execute(request).doOnSuccess(ignore -> LazyTableBuilder.this.schema.addTable(newTable)).thenReturn((Object)true);
                })).flatMap(Function.identity());
            }
        };
    }

    class LazyForeignKeyDSLBuilder
    extends ForeignKeyDSLBuilder {
        public LazyForeignKeyDSLBuilder() {
            super(LazyTableBuilder.this, null);
        }

        @Override
        public TableBuilder commit() {
            LazyTableBuilder.this.custom(table -> table.addForeignKey(this.builder));
            return LazyTableBuilder.this;
        }
    }

    class LazyIndexBuilder
    extends IndexBuilder {
        public LazyIndexBuilder() {
            super(LazyTableBuilder.this, null);
        }

        @Override
        public TableBuilder commit() {
            LazyTableBuilder.this.custom(table -> table.addIndex(this.index));
            return LazyTableBuilder.this;
        }
    }

    class LazyColumnBuilder
    implements ColumnBuilder {
        private final List<Consumer<RDBColumnMetadata>> operations = new ArrayList<Consumer<RDBColumnMetadata>>();

        LazyColumnBuilder() {
        }

        @Override
        public ColumnBuilder custom(Consumer<RDBColumnMetadata> consumer) {
            this.operations.add(consumer);
            return this;
        }

        @Override
        public ColumnBuilder name(String name) {
            this.operations.add(column -> column.setName(name));
            return this;
        }

        @Override
        public ColumnBuilder alias(String name) {
            this.operations.add(column -> column.setAlias(name));
            return this;
        }

        @Override
        public ColumnBuilder dataType(String dataType) {
            this.operations.add(column -> column.setDataType(dataType));
            return this;
        }

        @Override
        public ColumnBuilder type(String typeId) {
            this.operations.add(column -> column.setType(column.getDialect().convertDataType(typeId)));
            return this;
        }

        @Override
        public ColumnBuilder type(DataType type) {
            this.operations.add(column -> column.setType(type));
            return this;
        }

        @Override
        public ColumnBuilder comment(String comment) {
            this.operations.add(column -> column.setComment(comment));
            return this;
        }

        @Override
        public ColumnBuilder notNull() {
            this.operations.add(column -> column.setNotNull(true));
            return this;
        }

        @Override
        public ColumnBuilder primaryKey() {
            this.operations.add(column -> column.setPrimaryKey(true));
            return this;
        }

        @Override
        public ColumnBuilder columnDef(String def) {
            this.operations.add(column -> column.setColumnDefinition(def));
            return this;
        }

        @Override
        public ColumnBuilder defaultValue(DefaultValue value) {
            this.operations.add(column -> column.setDefaultValue(value));
            return this;
        }

        @Override
        public ColumnBuilder property(String propertyName, Object value) {
            this.operations.add(column -> column.setProperty(propertyName, value));
            return this;
        }

        @Override
        public ColumnBuilder length(int len) {
            this.operations.add(column -> column.setLength(len));
            return this;
        }

        @Override
        public ColumnBuilder length(int precision, int scale) {
            this.operations.add(column -> {
                column.setLength(precision);
                column.setScale(scale);
                column.setPrecision(precision);
            });
            return this;
        }

        @Override
        public TableBuilder commit() {
            LazyTableBuilder.this.custom((RDBTableMetadata table) -> {
                RDBColumnMetadata column = table.newColumn();
                for (Consumer<RDBColumnMetadata> operation : this.operations) {
                    operation.accept(column);
                }
                if (column.getValueCodec() == null) {
                    table.findFeature(ValueCodecFactory.ID).flatMap(factory -> factory.createValueCodec(column)).ifPresent(arg_0 -> ((RDBColumnMetadata)column).setValueCodec(arg_0));
                }
                table.addColumn(column);
            });
            return LazyTableBuilder.this;
        }
    }
}

