/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.operator.builder.fragments.term;

import java.util.List;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.term.AbstractTermFragmentBuilder;

public abstract class EnumInFragmentBuilder
extends AbstractTermFragmentBuilder {
    private final boolean not;

    public EnumInFragmentBuilder(boolean not) {
        super(not ? "nin" : "in", "\u679a\u4e3eIn");
        this.not = not;
    }

    @Override
    public SqlFragments createFragments(String columnFullName, RDBColumnMetadata column, Term term) {
        List<Object> values = this.convertList(column, term);
        long mask = 0L;
        boolean any = term.getOptions().contains("any");
        for (Object value : values) {
            if (value instanceof Number) {
                mask |= ((Number)value).longValue();
                continue;
            }
            if (!(value instanceof Enum)) continue;
            mask |= 1L << ((Enum)value).ordinal();
        }
        PrepareSqlFragments sql = this.bitAnd(columnFullName, mask);
        if (any) {
            sql.addSql(this.not ? "=" : "!=", "0");
        } else {
            sql.addSql(this.not ? "!=" : "=", columnFullName);
        }
        return sql;
    }

    protected abstract PrepareSqlFragments bitAnd(String var1, long var2);

    public boolean isNot() {
        return this.not;
    }
}

