/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.metadata;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;
import org.hswebframework.ezorm.core.meta.ObjectType;
import org.hswebframework.ezorm.rdb.metadata.RDBObjectType;

public class RDBIndexMetadata
implements ObjectMetadata {
    private String name;
    private String tableName;
    private String alias;
    private String comment;
    private List<IndexColumn> columns = new CopyOnWriteArrayList<IndexColumn>();
    private boolean unique;
    private boolean primaryKey;

    public RDBIndexMetadata(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name).append(" ").append(this.unique ? "unique index" : "index").append(" on ").append(this.tableName);
        builder.append("(");
        int index = 0;
        for (IndexColumn column : this.columns) {
            if (index++ != 0) {
                builder.append(",");
            }
            builder.append(column.getColumn()).append(" ").append(column.getSort().name());
        }
        builder.append(")");
        return builder.toString();
    }

    public boolean contains(String column) {
        return this.columns.stream().anyMatch(indexColumn -> indexColumn.getColumn().equals(column));
    }

    public ObjectType getObjectType() {
        return RDBObjectType.index;
    }

    public RDBIndexMetadata clone() {
        RDBIndexMetadata metadata = (RDBIndexMetadata)super.clone();
        metadata.columns.clear();
        this.columns.stream().map(IndexColumn::clone).forEach(metadata.columns::add);
        return metadata;
    }

    public boolean isChanged(RDBIndexMetadata old) {
        if (old.getColumns().size() != this.getColumns().size()) {
            return true;
        }
        Map nameMapping = this.getColumns().stream().collect(Collectors.toMap(IndexColumn::getColumn, Function.identity()));
        for (IndexColumn oldColumn : old.getColumns()) {
            IndexColumn column = (IndexColumn)nameMapping.get(oldColumn.column);
            if (column != null) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getComment() {
        return this.comment;
    }

    public List<IndexColumn> getColumns() {
        return this.columns;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setColumns(List<IndexColumn> columns) {
        this.columns = columns;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public RDBIndexMetadata() {
    }

    public static class IndexColumn
    implements Cloneable,
    Comparable<IndexColumn> {
        private String column;
        private IndexSort sort = IndexSort.asc;
        private int sortIndex;

        public static IndexColumn of(String column, IndexSort sort) {
            IndexColumn indexColumn = new IndexColumn();
            indexColumn.setColumn(column);
            indexColumn.setSort(sort);
            return indexColumn;
        }

        public IndexColumn clone() {
            return (IndexColumn)super.clone();
        }

        @Override
        public int compareTo(IndexColumn o) {
            return Integer.compare(this.sortIndex, o.sortIndex);
        }

        public String getColumn() {
            return this.column;
        }

        public IndexSort getSort() {
            return this.sort;
        }

        public int getSortIndex() {
            return this.sortIndex;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void setSort(IndexSort sort) {
            this.sort = sort;
        }

        public void setSortIndex(int sortIndex) {
            this.sortIndex = sortIndex;
        }
    }

    public static enum IndexSort {
        asc,
        desc;

    }
}

