/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.mapping.parser;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.rdb.codec.BooleanValueCodec;
import org.hswebframework.ezorm.rdb.codec.DateTimeCodec;
import org.hswebframework.ezorm.rdb.codec.EnumValueCodec;
import org.hswebframework.ezorm.rdb.codec.JsonValueCodec;
import org.hswebframework.ezorm.rdb.codec.NumberValueCodec;
import org.hswebframework.ezorm.rdb.mapping.EntityPropertyDescriptor;
import org.hswebframework.ezorm.rdb.mapping.annotation.Codec;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.ezorm.rdb.mapping.parser.ValueCodecResolver;

public class DefaultValueCodecResolver
implements ValueCodecResolver {
    private Map<Class<? extends Annotation>, BiFunction<EntityPropertyDescriptor, Annotation, ValueCodec>> annotationStrategies = new ConcurrentHashMap<Class<? extends Annotation>, BiFunction<EntityPropertyDescriptor, Annotation, ValueCodec>>();
    private Map<Class, Function<EntityPropertyDescriptor, ValueCodec>> typeStrategies = new ConcurrentHashMap<Class, Function<EntityPropertyDescriptor, ValueCodec>>();
    private Map<Predicate<Class>, Function<EntityPropertyDescriptor, ValueCodec>> predicateStrategies = new ConcurrentHashMap<Predicate<Class>, Function<EntityPropertyDescriptor, ValueCodec>>();
    public static final DefaultValueCodecResolver COMMONS = new DefaultValueCodecResolver();

    public <T extends Annotation> void register(Class<T> ann, BiFunction<EntityPropertyDescriptor, T, ValueCodec> codecFunction) {
        this.annotationStrategies.put(ann, codecFunction);
    }

    public void register(Class ann, Function<EntityPropertyDescriptor, ValueCodec> codecFunction) {
        this.typeStrategies.put(ann, codecFunction);
    }

    public void register(Predicate<Class> ann, Function<EntityPropertyDescriptor, ValueCodec> codecFunction) {
        this.predicateStrategies.put(ann, codecFunction);
    }

    @Override
    public Optional<ValueCodec> resolve(EntityPropertyDescriptor descriptor) {
        Set annotations = descriptor.getAnnotations().stream().filter(ann -> null != ann.annotationType().getAnnotation(Codec.class)).collect(Collectors.toSet());
        ArrayList<ValueCodec> codecs = new ArrayList<ValueCodec>();
        for (Annotation annotation : annotations) {
            BiFunction<EntityPropertyDescriptor, Annotation, ValueCodec> function = this.annotationStrategies.get(annotation.annotationType());
            if (function == null) continue;
            codecs.add(function.apply(descriptor, annotation));
        }
        if (codecs.size() == 1) {
            return Optional.of(codecs.get(0));
        }
        return Optional.ofNullable(this.typeStrategies.get(descriptor.getPropertyType())).map(func -> (ValueCodec)func.apply(descriptor)).map(Optional::of).orElseGet(() -> this.predicateStrategies.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(descriptor.getPropertyType())).map(e -> (ValueCodec)((Function)e.getValue()).apply(descriptor)).findFirst());
    }

    static {
        COMMONS.register(org.hswebframework.ezorm.rdb.mapping.annotation.DateTimeCodec.class, (EntityPropertyDescriptor field, T ann) -> new DateTimeCodec(ann.format(), field.getPropertyType()));
        COMMONS.register(JsonCodec.class, (EntityPropertyDescriptor field, T jsonCodec) -> JsonValueCodec.ofField(field.getField()));
        COMMONS.register(EnumCodec.class, (EntityPropertyDescriptor field, T jsonCodec) -> new EnumValueCodec(field.getPropertyType(), jsonCodec.toMask()));
        COMMONS.register(Enumerated.class, (EntityPropertyDescriptor field, T jsonCodec) -> new EnumValueCodec(field.getPropertyType(), jsonCodec.value() == EnumType.ORDINAL));
        COMMONS.register(Date.class::isAssignableFrom, (EntityPropertyDescriptor field) -> new DateTimeCodec("yyyy-MM-dd HH", field.getPropertyType()));
        COMMONS.register(Number.class::isAssignableFrom, (EntityPropertyDescriptor field) -> new NumberValueCodec(field.getPropertyType()));
        COMMONS.register(Boolean.class::isAssignableFrom, (EntityPropertyDescriptor field) -> new BooleanValueCodec(field.getColumn().getSqlType()));
        COMMONS.register((Class type) -> type.isPrimitive() && type == Byte.TYPE && type == Boolean.TYPE && type == Short.TYPE && type == Float.TYPE && type == Double.TYPE && type == Long.TYPE, (EntityPropertyDescriptor field) -> new NumberValueCodec(field.getPropertyType()));
        COMMONS.register(Enum.class::isAssignableFrom, (EntityPropertyDescriptor field) -> new EnumValueCodec(field.getPropertyType()));
        COMMONS.register(Enum[].class::isAssignableFrom, (EntityPropertyDescriptor field) -> new EnumValueCodec(field.getPropertyType()));
    }
}

