/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.ezorm.rdb.codec;

import java.math.BigDecimal;
import java.util.Date;
import java.util.function.Function;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.rdb.executor.NullValue;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.utils.StringUtils;
import org.hswebframework.utils.time.DateFormatter;

public class NumberValueCodec
implements ValueCodec {
    private Function<Number, Object> converter;

    public NumberValueCodec(Function<Number, Object> converter) {
        this.converter = converter;
    }

    public NumberValueCodec(Class javaType) {
        this.converter = javaType == Integer.TYPE || javaType == Integer.class ? Number::intValue : (javaType == Double.TYPE || javaType == Double.class ? Number::doubleValue : (javaType == Float.TYPE || javaType == Float.class ? Number::floatValue : (javaType == Long.TYPE || javaType == Long.class ? Number::longValue : (javaType == Byte.TYPE || javaType == Byte.class ? Number::byteValue : (javaType == Short.TYPE || javaType == Short.class ? Number::shortValue : (javaType == Boolean.TYPE || javaType == Boolean.class ? num -> num.byteValue() != 0 : (ClassUtils.instanceOf((Class)javaType, Date.class) ? num -> {
            try {
                Date date = (Date)javaType.newInstance();
                date.setTime(num.longValue());
                return date;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } : num -> num)))))));
    }

    public Object encode(Object value) {
        Date date;
        if (StringUtils.isNullOrEmpty((Object)value)) {
            return null;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (!StringUtils.isNumber((Object)value) && null != (date = DateFormatter.fromString((String)String.valueOf(value)))) {
            value = date.getTime();
        }
        if (value instanceof Number) {
            return this.converter.apply((Number)value);
        }
        if (StringUtils.isNumber((Object)value)) {
            return this.converter.apply(new BigDecimal(String.valueOf(value)));
        }
        if (Boolean.TRUE.equals(value)) {
            return this.converter.apply(1);
        }
        if (Boolean.FALSE.equals(value)) {
            return this.converter.apply(0);
        }
        if (value instanceof NullValue) {
            return value;
        }
        throw new IllegalArgumentException("\u503c" + value + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u5b57");
    }

    public Object decode(Object data) {
        Date date;
        if (data instanceof String) {
            if (StringUtils.isNumber((Object)data)) {
                data = new BigDecimal((String)data);
            }
        } else if (!StringUtils.isNumber((Object)data) && null != (date = DateFormatter.fromString((String)String.valueOf(data)))) {
            data = date.getTime();
        }
        if (data instanceof Number) {
            return this.converter.apply((Number)data);
        }
        return data;
    }
}

