/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformProgress {
    public static final ParseField TOTAL_DOCS = new ParseField("total_docs", new String[0]);
    public static final ParseField DOCS_REMAINING = new ParseField("docs_remaining", new String[0]);
    public static final ParseField PERCENT_COMPLETE = new ParseField("percent_complete", new String[0]);
    public static final ParseField DOCS_PROCESSED = new ParseField("docs_processed", new String[0]);
    public static final ParseField DOCS_INDEXED = new ParseField("docs_indexed", new String[0]);
    public static final ConstructingObjectParser<DataFrameTransformProgress, Void> PARSER = new ConstructingObjectParser("data_frame_transform_progress", true, a -> new DataFrameTransformProgress((Long)a[0], (Long)a[1], (Double)a[2], (Long)a[3], (Long)a[4]));
    private final Long totalDocs;
    private final Long remainingDocs;
    private final Double percentComplete;
    private final long documentsProcessed;
    private final long documentsIndexed;

    public static DataFrameTransformProgress fromXContent(XContentParser parser) {
        return (DataFrameTransformProgress)PARSER.apply(parser, null);
    }

    public DataFrameTransformProgress(Long totalDocs, Long remainingDocs, Double percentComplete, Long documentsProcessed, Long documentsIndexed) {
        this.totalDocs = totalDocs;
        this.remainingDocs = remainingDocs == null ? totalDocs : remainingDocs;
        this.percentComplete = percentComplete;
        this.documentsProcessed = documentsProcessed == null ? 0L : documentsProcessed;
        this.documentsIndexed = documentsIndexed == null ? 0L : documentsIndexed;
    }

    @Nullable
    public Double getPercentComplete() {
        return this.percentComplete;
    }

    @Nullable
    public Long getTotalDocs() {
        return this.totalDocs;
    }

    @Nullable
    public Long getRemainingDocs() {
        return this.remainingDocs;
    }

    public long getDocumentsProcessed() {
        return this.documentsProcessed;
    }

    public long getDocumentsIndexed() {
        return this.documentsIndexed;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        DataFrameTransformProgress that = (DataFrameTransformProgress)other;
        return Objects.equals(this.remainingDocs, that.remainingDocs) && Objects.equals(this.totalDocs, that.totalDocs) && Objects.equals(this.percentComplete, that.percentComplete) && Objects.equals(this.documentsIndexed, that.documentsIndexed) && Objects.equals(this.documentsProcessed, that.documentsProcessed);
    }

    public int hashCode() {
        return Objects.hash(this.remainingDocs, this.totalDocs, this.percentComplete, this.documentsIndexed, this.documentsProcessed);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TOTAL_DOCS);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCS_REMAINING);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), PERCENT_COMPLETE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCS_PROCESSED);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DOCS_INDEXED);
    }
}

