/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.FeatureDescription;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.UpdateSite;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;
import org.eclipse.tycho.packaging.UpdateSiteAssembler;

public class UpdateSiteMojo
extends AbstractTychoPackagingMojo {
    private File target;
    private File basedir;
    private boolean inlineArchives;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.target.mkdirs();
        try {
            FileUtils.cleanDirectory((File)this.target);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to delete old update site content: " + this.target.getAbsolutePath(), (Throwable)e);
        }
        try {
            File srcAssociateSitesFile;
            UpdateSite site = UpdateSite.read((File)new File(this.basedir, "site.xml"));
            UpdateSiteAssembler assembler = new UpdateSiteAssembler(this.session, this.target);
            if (this.inlineArchives) {
                assembler.setArchives(site.getArchives());
            }
            this.getDependencyWalker().walk((ArtifactDependencyVisitor)assembler);
            this.getDependencyWalker().traverseUpdateSite(site, new ArtifactDependencyVisitor(){

                public boolean visitFeature(FeatureDescription feature) {
                    FeatureRef featureRef = feature.getFeatureRef();
                    String id = featureRef.getId();
                    ReactorProject otherProject = feature.getMavenProject();
                    String version = otherProject != null ? otherProject.getExpandedVersion() : feature.getKey().getVersion();
                    String url = "features/" + id + "_" + version + ".jar";
                    ((UpdateSite.SiteFeatureRef)featureRef).setUrl(url);
                    featureRef.setVersion(version);
                    return false;
                }
            });
            if (this.inlineArchives) {
                site.removeArchives();
            }
            File file = new File(this.target, "site.xml");
            UpdateSite.write((UpdateSite)site, (File)file);
            if (site.getAssociateSitesUrl() != null && (srcAssociateSitesFile = new File(this.basedir, site.getAssociateSitesUrl())).exists()) {
                FileUtils.copyFile((File)srcAssociateSitesFile, (File)new File(this.target + File.separator + site.getAssociateSitesUrl()));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

