/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.request;

import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.leshan.core.Destroyable;
import org.eclipse.leshan.core.californium.AsyncRequestObserver;
import org.eclipse.leshan.core.californium.CoapAsyncRequestObserver;
import org.eclipse.leshan.core.californium.CoapResponseCallback;
import org.eclipse.leshan.core.californium.CoapSyncRequestObserver;
import org.eclipse.leshan.core.californium.EndpointContextUtil;
import org.eclipse.leshan.core.californium.SyncRequestObserver;
import org.eclipse.leshan.core.link.LinkParser;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.DownlinkRequest;
import org.eclipse.leshan.core.request.DownlinkRequestVisitor;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.response.ErrorCallback;
import org.eclipse.leshan.core.response.LwM2mResponse;
import org.eclipse.leshan.core.response.ResponseCallback;
import org.eclipse.leshan.core.util.NamedThreadFactory;
import org.eclipse.leshan.core.util.Validate;
import org.eclipse.leshan.server.californium.request.CoapRequestBuilder;
import org.eclipse.leshan.server.californium.request.LwM2mResponseBuilder;
import org.eclipse.leshan.server.request.LowerLayerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSender
implements Destroyable {
    static final Logger LOG = LoggerFactory.getLogger(RequestSender.class);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("Leshan Async Request timeout"));
    private final Endpoint nonSecureEndpoint;
    private final Endpoint secureEndpoint;
    private final LwM2mDecoder decoder;
    private final LwM2mEncoder encoder;
    private final LinkParser linkParser;
    private final ConcurrentNavigableMap<String, Request> ongoingRequests = new ConcurrentSkipListMap<String, Request>();
    private AtomicLong idGenerator = new AtomicLong(0L);

    public RequestSender(Endpoint secureEndpoint, Endpoint nonSecureEndpoint, LwM2mEncoder encoder, LwM2mDecoder decoder, LinkParser linkParser) {
        this.secureEndpoint = secureEndpoint;
        this.nonSecureEndpoint = nonSecureEndpoint;
        this.encoder = encoder;
        this.decoder = decoder;
        this.linkParser = linkParser;
    }

    public <T extends LwM2mResponse> T sendLwm2mRequest(final String endpointName, Identity destination, String sessionId, final LwM2mModel model, String rootPath, final DownlinkRequest<T> request, LowerLayerConfig lowerLayerConfig, long timeoutInMs, boolean allowConnectionInitiation) throws InterruptedException {
        CoapRequestBuilder coapClientRequestBuilder = new CoapRequestBuilder(destination, rootPath, sessionId, endpointName, model, this.encoder, allowConnectionInitiation, lowerLayerConfig);
        request.accept((DownlinkRequestVisitor)coapClientRequestBuilder);
        final Request coapRequest = coapClientRequestBuilder.getRequest();
        SyncRequestObserver syncMessageObserver = new SyncRequestObserver<T>(coapRequest, timeoutInMs){

            public T buildResponse(Response coapResponse) {
                LwM2mResponseBuilder lwm2mResponseBuilder = new LwM2mResponseBuilder(coapRequest, coapResponse, endpointName, model, RequestSender.this.decoder, RequestSender.this.linkParser);
                request.accept(lwm2mResponseBuilder);
                return lwm2mResponseBuilder.getResponse();
            }
        };
        coapRequest.addMessageObserver((MessageObserver)syncMessageObserver);
        this.addOngoingRequest(sessionId, coapRequest);
        if (destination.isSecure()) {
            this.secureEndpoint.sendRequest(coapRequest);
        } else {
            this.nonSecureEndpoint.sendRequest(coapRequest);
        }
        return (T)syncMessageObserver.waitForResponse();
    }

    public <T extends LwM2mResponse> void sendLwm2mRequest(final String endpointName, Identity destination, String sessionId, final LwM2mModel model, String rootPath, final DownlinkRequest<T> request, LowerLayerConfig lowerLayerConfig, long timeoutInMs, ResponseCallback<T> responseCallback, ErrorCallback errorCallback, boolean allowConnectionInitiation) {
        Validate.notNull(responseCallback);
        Validate.notNull((Object)errorCallback);
        CoapRequestBuilder coapClientRequestBuilder = new CoapRequestBuilder(destination, rootPath, sessionId, endpointName, model, this.encoder, allowConnectionInitiation, lowerLayerConfig);
        request.accept((DownlinkRequestVisitor)coapClientRequestBuilder);
        final Request coapRequest = coapClientRequestBuilder.getRequest();
        AsyncRequestObserver obs = new AsyncRequestObserver<T>(coapRequest, responseCallback, errorCallback, timeoutInMs, this.executor){

            public T buildResponse(Response coapResponse) {
                LwM2mResponseBuilder lwm2mResponseBuilder = new LwM2mResponseBuilder(coapRequest, coapResponse, endpointName, model, RequestSender.this.decoder, RequestSender.this.linkParser);
                request.accept(lwm2mResponseBuilder);
                return lwm2mResponseBuilder.getResponse();
            }
        };
        coapRequest.addMessageObserver((MessageObserver)obs);
        this.addOngoingRequest(sessionId, coapRequest);
        if (destination.isSecure()) {
            this.secureEndpoint.sendRequest(coapRequest);
        } else {
            this.nonSecureEndpoint.sendRequest(coapRequest);
        }
    }

    public Response sendCoapRequest(Identity destination, String sessionId, Request coapRequest, long timeoutInMs, boolean allowConnectionInitiation) throws InterruptedException {
        if (coapRequest.getDestinationContext() == null) {
            EndpointContext context = EndpointContextUtil.extractContext((Identity)destination, (boolean)allowConnectionInitiation);
            coapRequest.setDestinationContext(context);
        } else {
            LOG.warn("Destination context was not set by Leshan for this request. The context is used to ensure you talk to the right peer. Bad usage could bring to security issue. {}", (Object)coapRequest);
        }
        CoapSyncRequestObserver syncMessageObserver = new CoapSyncRequestObserver(coapRequest, timeoutInMs);
        coapRequest.addMessageObserver((MessageObserver)syncMessageObserver);
        this.addOngoingRequest(sessionId, coapRequest);
        if (destination.isSecure()) {
            this.secureEndpoint.sendRequest(coapRequest);
        } else {
            this.nonSecureEndpoint.sendRequest(coapRequest);
        }
        return syncMessageObserver.waitForCoapResponse();
    }

    public void sendCoapRequest(Identity destination, String sessionId, Request coapRequest, long timeoutInMs, CoapResponseCallback responseCallback, ErrorCallback errorCallback, boolean allowConnectionInitiation) {
        Validate.notNull((Object)responseCallback);
        Validate.notNull((Object)errorCallback);
        if (coapRequest.getDestinationContext() == null) {
            EndpointContext context = EndpointContextUtil.extractContext((Identity)destination, (boolean)allowConnectionInitiation);
            coapRequest.setDestinationContext(context);
        } else {
            LOG.warn("Destination context was not set by Leshan for this request. The context is used to ensure you talk to the right peer. Bad usage could bring to security issue.{}", (Object)coapRequest);
        }
        CoapAsyncRequestObserver obs = new CoapAsyncRequestObserver(coapRequest, responseCallback, errorCallback, timeoutInMs, this.executor);
        coapRequest.addMessageObserver((MessageObserver)obs);
        this.addOngoingRequest(sessionId, coapRequest);
        if (destination.isSecure()) {
            this.secureEndpoint.sendRequest(coapRequest);
        } else {
            this.nonSecureEndpoint.sendRequest(coapRequest);
        }
    }

    public void cancelRequests(String sessionID) {
        Validate.notNull((Object)sessionID);
        SortedMap requests = this.ongoingRequests.subMap((Object)RequestSender.getFloorKey(sessionID), (Object)RequestSender.getCeilingKey(sessionID));
        for (Request coapRequest : requests.values()) {
            coapRequest.cancel();
        }
        requests.clear();
    }

    private static String getFloorKey(String sessionID) {
        return sessionID + '#';
    }

    private static String getCeilingKey(String sessionID) {
        return sessionID + "#A";
    }

    private static String getKey(String sessionID, long requestId) {
        return sessionID + '#' + requestId;
    }

    private void addOngoingRequest(String sessionID, Request coapRequest) {
        if (sessionID != null) {
            CleanerMessageObserver observer = new CleanerMessageObserver(sessionID, coapRequest);
            coapRequest.addMessageObserver((MessageObserver)observer);
            this.ongoingRequests.put(observer.getRequestKey(), coapRequest);
        }
    }

    private void removeOngoingRequest(String key, Request coapRequest) {
        Validate.notNull((Object)key);
        this.ongoingRequests.remove(key, coapRequest);
    }

    public void destroy() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Destroying RequestSender was interrupted.", (Throwable)e);
        }
    }

    private class CleanerMessageObserver
    extends MessageObserverAdapter {
        private final String requestKey;
        private final Request coapRequest;

        public CleanerMessageObserver(String sessionID, Request coapRequest) {
            this.requestKey = RequestSender.getKey(sessionID, RequestSender.this.idGenerator.incrementAndGet());
            this.coapRequest = coapRequest;
        }

        public String getRequestKey() {
            return this.requestKey;
        }

        public void onRetransmission() {
        }

        public void onResponse(Response response) {
            RequestSender.this.removeOngoingRequest(this.requestKey, this.coapRequest);
        }

        public void onAcknowledgement() {
        }

        protected void failed() {
            RequestSender.this.removeOngoingRequest(this.requestKey, this.coapRequest);
        }

        public void onCancel() {
            RequestSender.this.removeOngoingRequest(this.requestKey, this.coapRequest);
        }
    }
}

